/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.markdown.core.block.NestableBlock;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class QuoteBlock
extends NestableBlock {
    private static final Pattern startPattern = Pattern.compile(">\\s?(.*)");
    private static final Pattern linePattern = Pattern.compile("(?:>\\s?)?(.*)");
    private int blockLineCount = 0;
    private Block nestedBlock = null;

    public boolean canStart(String line, int lineOffset) {
        return startPattern.matcher(line.substring(lineOffset)).matches();
    }

    protected int processLineContent(String line, int offset) {
        String text = line.substring(offset);
        if (this.blockLineCount == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, new Attributes());
        }
        if (this.markupLanguage.isEmptyLine(text)) {
            this.setClosed(true);
            return offset;
        }
        Matcher matcher = linePattern.matcher(text);
        if (!matcher.matches()) {
            this.setClosed(true);
            return offset;
        }
        int contentStart = offset + matcher.start(1);
        if (this.nestedBlock != null) {
            if (!(this.nestedBlock instanceof QuoteBlock) && this.canStart(line, contentStart)) {
                this.nestedBlock.setClosed(true);
                this.nestedBlock = null;
                this.processNextBlock(line, contentStart);
            } else {
                int processed = this.nestedBlock.processLine(line, contentStart);
                if (this.nestedBlock.isClosed()) {
                    this.nestedBlock = null;
                    if (processed >= contentStart && processed < line.length()) {
                        this.processNextBlock(line, contentStart);
                    }
                }
            }
        } else {
            this.processNextBlock(line, contentStart);
        }
        ++this.blockLineCount;
        return -1;
    }

    private void processNextBlock(String line, int contentStart) {
        for (Block block : this.getMarkupLanguage().getBlocks()) {
            if (!block.canStart(line, contentStart)) continue;
            this.nestedBlock = this.clone(block);
            break;
        }
        this.nestedBlock.processLine(line, contentStart);
        if (this.nestedBlock.isClosed()) {
            this.nestedBlock = null;
        }
    }

    private Block clone(Block block) {
        Block clonedBlock = block.clone();
        clonedBlock.setParser(this.getParser());
        clonedBlock.setState(this.getState());
        return clonedBlock;
    }

    public void setClosed(boolean closed) {
        if (this.nestedBlock != null) {
            this.nestedBlock.setClosed(true);
            this.nestedBlock = null;
        }
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

