/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mylyn.internal.reviews.ui.compare.FileRevisionEditorInput;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class FileRevisionTypedElement
implements IAdaptable,
IStreamContentAccessor,
ITypedElement {
    private final IFileRevision fileRevision;
    private final IProgressMonitor runningMonitor;
    private ISharedDocumentAdapter sharedDocumentAdapter;

    public FileRevisionTypedElement(IFileRevision fileRevision, IProgressMonitor monitor) {
        this.fileRevision = fileRevision;
        this.runningMonitor = monitor;
    }

    private IFileRevision getFileRevision() {
        return this.fileRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAdapter(Class adapter) {
        if (ISharedDocumentAdapter.class.equals((Object)adapter)) {
            FileRevisionTypedElement fileRevisionTypedElement = this;
            synchronized (fileRevisionTypedElement) {
                if (this.sharedDocumentAdapter == null) {
                    this.sharedDocumentAdapter = new SharedDocumentAdapter(){

                        public IEditorInput getDocumentKey(Object element) {
                            return FileRevisionTypedElement.this.getDocumentKey(element);
                        }

                        public void flushDocument(IDocumentProvider provider, IEditorInput documentKey, IDocument document, boolean overwrite) {
                        }
                    };
                }
                return this.sharedDocumentAdapter;
            }
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public InputStream getContents() throws CoreException {
        return this.fileRevision.getStorage(this.runningMonitor).getContents();
    }

    public IEditorInput getDocumentKey(Object element) {
        if (element instanceof FileRevisionTypedElement && element.equals(this)) {
            return new FileRevisionEditorInput(this.fileRevision, this.runningMonitor);
        }
        return null;
    }

    public String getName() {
        return this.fileRevision.getName();
    }

    public Image getImage() {
        return CompareUI.getImage((String)this.getType());
    }

    public String getType() {
        String extension = FilenameUtils.getExtension((String)this.getName());
        return extension != null && extension.length() > 0 ? extension : "txt";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileRevisionTypedElement) {
            FileRevisionTypedElement otherElement = (FileRevisionTypedElement)obj;
            return otherElement.getFileRevision().equals(this.fileRevision);
        }
        return false;
    }

    public int hashCode() {
        return this.fileRevision.hashCode();
    }
}

