/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.validation;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.textile.core.validation.BlockWhitespaceRule;
import org.eclipse.mylyn.wikitext.core.validation.MarkupValidator;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.tests.TestUtil;

public class BlockWhitespaceRuleTest
extends TestCase {
    private BlockWhitespaceRule rule;
    private MarkupValidator validator;

    public void setUp() {
        this.rule = new BlockWhitespaceRule();
        this.validator = new MarkupValidator();
        this.validator.getRules().add(this.rule);
    }

    public void testNoMatch() {
        ValidationProblem problem = this.rule.findProblem("bc. \nfoo", 0, "bc. \nfoo".length());
        TestUtil.println(problem);
        BlockWhitespaceRuleTest.assertNull((Object)problem);
    }

    public void testNoMatch2() {
        ValidationProblem problem = this.rule.findProblem("\nabc.\nfoo", 0, "\nabc.\nfoo".length());
        TestUtil.println(problem);
        BlockWhitespaceRuleTest.assertNull((Object)problem);
    }

    public void testMatch() {
        ValidationProblem problem = this.rule.findProblem("bc.\nfoo", 0, "bc.\nfoo".length());
        TestUtil.println(problem);
        BlockWhitespaceRuleTest.assertNotNull((Object)problem);
        BlockWhitespaceRuleTest.assertEquals((int)0, (int)problem.getOffset());
    }

    public void testMatch2() {
        ValidationProblem problem = this.rule.findProblem("\nbc.\nfoo", 0, "\nbc.\nfoo".length());
        TestUtil.println(problem);
        BlockWhitespaceRuleTest.assertNotNull((Object)problem);
        BlockWhitespaceRuleTest.assertEquals((int)1, (int)problem.getOffset());
    }

    public void testMatch3() {
        ValidationProblem problem = this.rule.findProblem("\n\n\nbc..\nfoo", 0, "\n\n\nbc..\nfoo".length());
        TestUtil.println(problem);
        BlockWhitespaceRuleTest.assertNotNull((Object)problem);
        BlockWhitespaceRuleTest.assertEquals((int)3, (int)problem.getOffset());
    }

    public void testValidator() {
        String markup = "h1. Foo\n\nbc. bar\n\npre.\nsdf\n\nbc.\n\n";
        List result = this.validator.validate(markup);
        BlockWhitespaceRuleTest.assertEquals((int)2, (int)result.size());
        TestUtil.println(result);
        BlockWhitespaceRuleTest.assertEquals((int)18, (int)((ValidationProblem)result.get(0)).getOffset());
        BlockWhitespaceRuleTest.assertEquals((int)4, (int)((ValidationProblem)result.get(0)).getLength());
        BlockWhitespaceRuleTest.assertEquals((int)28, (int)((ValidationProblem)result.get(1)).getOffset());
        BlockWhitespaceRuleTest.assertEquals((int)3, (int)((ValidationProblem)result.get(1)).getLength());
    }
}

