/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.validation;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.validation.CommentValidationRule;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;

public class CommentValidationRuleTest
extends TestCase {
    private CommentValidationRule rule;

    protected void setUp() throws Exception {
        super.setUp();
        this.rule = new CommentValidationRule();
    }

    public void testOk() {
        String markup = "a <!-- valid comment -->";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        CommentValidationRuleTest.assertNull((Object)problem);
    }

    public void testFail1() {
        String markup = "a <!--- bogus comment -->";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        CommentValidationRuleTest.assertNotNull((Object)problem);
        CommentValidationRuleTest.assertEquals((int)2, (int)problem.getOffset());
        CommentValidationRuleTest.assertEquals((int)5, (int)problem.getLength());
    }

    public void testFail2() {
        String markup = "a <!--- bogus comment ----->";
        ValidationProblem problem = this.rule.findProblem(markup, 0, markup.length());
        CommentValidationRuleTest.assertNotNull((Object)problem);
        int offset = problem.getOffset() + problem.getLength();
        problem = this.rule.findProblem(markup, offset, markup.length() - offset);
        CommentValidationRuleTest.assertNotNull((Object)problem);
        CommentValidationRuleTest.assertEquals((int)22, (int)problem.getOffset());
        CommentValidationRuleTest.assertEquals((int)6, (int)problem.getLength());
    }
}

