/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client.rest;

import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.ApprovalUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.rest.CommentInput;

public class ReviewInput {
    private final String message;
    private Map<String, CommentInput[]> comments;
    private Map<String, Short> labels;

    public ReviewInput(String msg) {
        Assert.isLegal((msg != null ? 1 : 0) != 0);
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, CommentInput[]> getComments() {
        return this.comments;
    }

    public void setComments(Map<String, CommentInput[]> comments) {
        this.comments = comments;
    }

    public void setApprovals(Set<ApprovalCategoryValue.Id> approvals) {
        if (approvals == null || approvals.isEmpty()) {
            return;
        }
        this.labels = new HashMap<String, Short>(approvals.size());
        for (ApprovalCategoryValue.Id approval : approvals) {
            String labelName = ApprovalUtil.findCategoryNameById(approval.getParentKey().get());
            labelName = labelName.replace(' ', '-');
            Short voteValue = approval.get();
            this.labels.put(labelName, voteValue);
        }
    }
}

