/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.html.HTML;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.core.HtmlTag;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.GerritConfigX;

public class GerritHtmlProcessor {
    private GerritConfigX config;
    private String xsrfKey;
    private String xGerritAuth;

    private static GerritConfigX gerritConfigFromString(String token) {
        try {
            JSonSupport support = new JSonSupport();
            return (GerritConfigX)((Object)support.parseResponse(token, (Type)((Object)GerritConfigX.class)));
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", "Failed to deserialize Gerrit configuration: '" + token + "'", (Throwable)e));
            return null;
        }
    }

    private static String getText(HtmlStreamTokenizer tokenizer) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder();
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TEXT) {
                sb.append(token.toString());
            } else if (token.getType() != HtmlStreamTokenizer.Token.COMMENT) break;
            token = tokenizer.nextToken();
        }
        return StringEscapeUtils.unescapeHtml((String)sb.toString());
    }

    public GerritConfigX getConfig() {
        return this.config;
    }

    public String getXsrfKey() {
        return this.xsrfKey;
    }

    public String getXGerritAuth() {
        return this.xGerritAuth;
    }

    public void parse(InputStream in, String charset) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset));
        HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
        try {
            HtmlStreamTokenizer.Token token = tokenizer.nextToken();
            while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                HtmlTag tag;
                if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HTML.Tag.SCRIPT) {
                    String text = GerritHtmlProcessor.getText(tokenizer);
                    text = text.replaceAll("\n", "");
                    text = text.replaceAll("\\s+", " ");
                    this.parse(text);
                }
                token = tokenizer.nextToken();
            }
        }
        catch (ParseException parseException) {
            throw new IOException("Error reading url");
        }
    }

    private void parse(String text) {
        String[] tokens;
        Pattern p = Pattern.compile("var gerrit_hostpagedata=\\{(\"version\":\"([^\"]+)\",)?\"config\":");
        String configXsrfToken = "hostpagedata.xsrfToken=\"";
        String configXGerritAuth = "hostpagedata.xGerritAuth=\"";
        String[] stringArray = tokens = text.split(";gerrit_");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            Matcher m = p.matcher(token);
            if (m.find()) {
                token = token.substring(m.toMatchResult().group(0).length());
                token = token.substring(0, token.length() - 1);
                this.config = GerritHtmlProcessor.gerritConfigFromString(token);
            } else if (token.startsWith(configXsrfToken)) {
                token = token.substring(configXsrfToken.length());
                this.xsrfKey = token = token.substring(0, token.length() - 1);
            } else if (token.startsWith(configXGerritAuth)) {
                token = token.substring(configXGerritAuth.length());
                this.xGerritAuth = token = token.substring(0, token.length() - 1);
            }
            ++n2;
        }
    }
}

