/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.commands;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.gerrit.dashboard.GerritPlugin;
import org.eclipse.mylyn.gerrit.dashboard.ui.GerritUi;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.GerritServerUtility;
import org.eclipse.mylyn.gerrit.dashboard.ui.views.GerritTableView;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.handlers.IHandlerService;

public class SelectReviewSiteHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Search Gerrit locations ...";
    private GerritServerUtility fServerUtil = null;
    private Map<TaskRepository, String> fMapRepoServer = null;

    public Object execute(ExecutionEvent aEvent) {
        GerritPlugin.Ftracer.traceInfo("Collecting the gerrit review locations");
        final GerritTableView reviewTableView = GerritTableView.getActiveView();
        reviewTableView.openView();
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = "DASHBOARD_UI";
            }

            public boolean belongsTo(Object aFamily) {
                return this.familyName.equals(aFamily);
            }

            public IStatus run(IProgressMonitor aMonitor) {
                String serverToUsed;
                aMonitor.beginTask(SelectReviewSiteHandler.COMMAND_MESSAGE, -1);
                SelectReviewSiteHandler.this.fServerUtil = GerritServerUtility.getInstance();
                SelectReviewSiteHandler.this.fMapRepoServer = SelectReviewSiteHandler.this.fServerUtil.getGerritMapping();
                if (!SelectReviewSiteHandler.this.fMapRepoServer.isEmpty()) {
                    Set mapSet = SelectReviewSiteHandler.this.fMapRepoServer.keySet();
                    GerritPlugin.Ftracer.traceInfo("-------------------");
                    for (TaskRepository key : mapSet) {
                        GerritPlugin.Ftracer.traceInfo("Map Key repo name : " + key.getRepositoryLabel() + "\t URL: " + (String)SelectReviewSiteHandler.this.fMapRepoServer.get(key));
                    }
                }
                if ((serverToUsed = SelectReviewSiteHandler.this.fServerUtil.getLastSavedGerritServer()) != null) {
                    reviewTableView.processCommands("my watched changes");
                } else {
                    GerritPlugin.Ftracer.traceInfo("Need to open the Dialogue to fill a gerrit server ");
                    IWorkbench workbench = GerritUi.getDefault().getWorkbench();
                    IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
                    try {
                        handlerService.executeCommand("org.eclipse.mylyn.gerrit.dashboard.ui.addGerritSite", null);
                    }
                    catch (Exception ex) {
                        GerritPlugin.Ftracer.traceError("Exception: " + ex.toString());
                    }
                }
                aMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }
}

