/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.ui.internal.commands;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.gerrit.dashboard.GerritPlugin;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.GerritServerUtility;
import org.eclipse.mylyn.gerrit.dashboard.ui.internal.utils.UIUtils;
import org.eclipse.mylyn.gerrit.dashboard.ui.views.GerritTableView;
import org.eclipse.mylyn.internal.tasks.ui.wizards.EditRepositoryWizard;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.TaskRepositoryWizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class AddGerritSiteHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Add a Gerrit location ...";
    private GerritServerUtility fServerUtil = null;
    private Map<TaskRepository, String> fMapRepoServer = null;

    public Object execute(ExecutionEvent aEvent) {
        GerritPlugin.Ftracer.traceInfo("Create the Add button to search the Gerrit location ");
        String menuItemText = "";
        this.fServerUtil = GerritServerUtility.getInstance();
        Object obj = aEvent.getTrigger();
        Map param = aEvent.getParameters();
        GerritTableView reviewTableView = GerritTableView.getActiveView();
        if (obj instanceof Event) {
            Event ev = (Event)obj;
            Widget objWidget = ev.widget;
            if (objWidget instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)objWidget;
                menuItemText = menuItem.getText();
                GerritPlugin.Ftracer.traceInfo("MenuItem: " + menuItemText + "\t value: " + (String)param.get(menuItemText) + " VS saved: " + this.fServerUtil.getLastSavedGerritServer());
                this.fMapRepoServer = this.fServerUtil.getGerritMapping();
                String stURL = this.fServerUtil.getMenuSelectionURL(menuItemText);
                GerritPlugin.Ftracer.traceInfo("URL for the menuItemText: " + stURL);
                if (!this.fMapRepoServer.isEmpty()) {
                    Set<TaskRepository> mapSet = this.fMapRepoServer.keySet();
                    GerritPlugin.Ftracer.traceInfo("-------------------");
                    for (TaskRepository key : mapSet) {
                        GerritPlugin.Ftracer.traceInfo("Map Key name: " + key.getRepositoryLabel() + "\t URL: " + this.fMapRepoServer.get(key));
                    }
                }
                reviewTableView.openView();
                if (stURL != null) {
                    if (stURL.equals(this.fServerUtil.getLastSavedGerritServer())) {
                        GerritPlugin.Ftracer.traceInfo("LAST SAVED server is the SAME ");
                        this.fServerUtil.getReviewListFromServer();
                        reviewTableView.processCommands("my watched changes");
                        return Status.OK_STATUS;
                    }
                    this.fServerUtil.saveLastGerritServer(stURL);
                    this.fServerUtil.getReviewListFromServer();
                    reviewTableView.processCommands("my watched changes");
                    return Status.OK_STATUS;
                }
            }
        }
        UIUtils.showErrorDialog("Use Button [Task Repositories...] to define a new Gerrit Server", "Button [Add Gerrit Repository...] is not ready");
        return obj;
    }

    private Object openDialogue() {
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                this.familyName = "DASHBOARD_UI";
            }

            public boolean belongsTo(Object aFamily) {
                return this.familyName.equals(aFamily);
            }

            public IStatus run(IProgressMonitor aMonitor) {
                aMonitor.beginTask(AddGerritSiteHandler.COMMAND_MESSAGE, -1);
                TaskRepository taskRepository = AddGerritSiteHandler.this.getTaskRepository("");
                GerritPlugin.Ftracer.traceInfo("repository:   " + taskRepository.getUrl());
                final EditRepositoryWizard wizard = new EditRepositoryWizard(taskRepository);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TaskRepositoryWizardDialog dialog = new TaskRepositoryWizardDialog(wizard.getShell(), (IWizard)wizard);
                        dialog.create();
                        dialog.setBlockOnOpen(true);
                        dialog.open();
                    }
                });
                taskRepository = wizard.getRepository();
                if (taskRepository.getUrl().isEmpty() || taskRepository.getUrl().endsWith("https://")) {
                    GerritPlugin.Ftracer.traceInfo("AFTER: repository: CANCEL ");
                } else {
                    GerritPlugin.Ftracer.traceInfo("AFTER: repository: :  FINISH ");
                    AddGerritSiteHandler.this.fServerUtil.saveLastGerritServer(taskRepository.getUrl());
                    TaskRepository taskRepositoryTmp = AddGerritSiteHandler.this.fServerUtil.getTaskRepo(taskRepository.getUrl());
                    if (taskRepositoryTmp == null) {
                        AddGerritSiteHandler.this.fServerUtil.getGerritMapping();
                    }
                    AddGerritSiteHandler.this.fServerUtil.getReviewListFromServer();
                    GerritTableView reviewTableView = GerritTableView.getActiveView();
                    reviewTableView.processCommands("my watched changes");
                }
                GerritPlugin.Ftracer.traceInfo("AFTER: repository: :  " + taskRepository.getUrl() + "\n\t repo: " + taskRepository.getRepositoryUrl());
                aMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    private TaskRepository getTaskRepository(String aUrl) {
        TaskRepository taskRepo = null;
        taskRepo = GerritServerUtility.getInstance().getTaskRepo(aUrl);
        if (taskRepo == null) {
            taskRepo = aUrl != null ? new TaskRepository("org.eclipse.mylyn.gerrit", aUrl) : new TaskRepository("org.eclipse.mylyn.gerrit", "https://");
        } else {
            GerritPlugin.Ftracer.traceInfo("Repo already in list:  " + taskRepo.getRepositoryLabel());
        }
        return taskRepo;
    }
}

