/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import com.google.gerrit.reviewdb.Patch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.internal.gerrit.core.GerritOperationFactory;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.SaveDraftRequest;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.internal.gerrit.ui.egit.GitFileRevisionUtils;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.team.core.history.IFileRevision;

public class GerritReviewBehavior
extends ReviewBehavior {
    private Repository repository = null;

    public GerritReviewBehavior(ITask task) {
        super(task);
    }

    public GerritReviewBehavior(ITask task, Repository repository) {
        super(task);
        this.repository = repository;
    }

    public GerritOperationFactory getOperationFactory() {
        return GerritUiPlugin.getDefault().getOperationFactory();
    }

    public IStatus addComment(IReviewItem item, IComment comment, IProgressMonitor monitor) {
        short side = 1;
        String id = item.getId();
        if (id.startsWith("base-")) {
            id = id.substring(5);
            side = 0;
        }
        Patch.Key key = Patch.Key.parse((String)id);
        for (ILocation location : comment.getLocations()) {
            if (!(location instanceof ILineLocation)) continue;
            ILineLocation lineLocation = (ILineLocation)location;
            SaveDraftRequest request = new SaveDraftRequest(key, lineLocation.getRangeMin(), side);
            request.setMessage(comment.getDescription());
            GerritOperation operation = this.getOperationFactory().createSaveDraftOperation(this.getTask(), request);
            return operation.run(monitor);
        }
        throw new RuntimeException("Internal Exception. No line location for comment. Comment: " + comment.getId());
    }

    public IFileRevision getFileRevision(IFileVersion reviewFileVersion) {
        if (this.repository != null) {
            return GitFileRevisionUtils.getFileRevision(this.repository, reviewFileVersion);
        }
        return null;
    }
}

