/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.commons.core.ExtensionPointReader;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskJobFactory;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.Messages;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.SubmitTaskAttachmentJob;
import org.eclipse.mylyn.internal.tasks.core.sync.SubmitTaskJob;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeQueriesJob;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeRepositoriesJob;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizeTasksJob;
import org.eclipse.mylyn.internal.tasks.core.sync.UpdateRepositoryConfigurationJob;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskJobListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskAttachmentSource;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;
import org.eclipse.mylyn.tasks.core.sync.TaskJob;

public class TaskJobFactory
implements ITaskJobFactory {
    private static final String ALL_CONNECTORS = "org.eclipse.mylyn.tasks.core.all.connectors";
    private static Map<String, List<TaskJobListener>> taskJobListeners;
    private final TaskList taskList;
    private final TaskDataManager taskDataManager;
    private final IRepositoryManager repositoryManager;
    private final IRepositoryModel tasksModel;

    protected static synchronized List<TaskJobListener> getTaskJobListeners(AbstractRepositoryConnector connector) {
        List<TaskJobListener> listeners;
        if (taskJobListeners == null) {
            taskJobListeners = new HashMap<String, List<TaskJobListener>>();
            listeners = TaskJobFactory.loadTaskJobListeners("");
            taskJobListeners.put(ALL_CONNECTORS, listeners);
        }
        if (taskJobListeners.get(connector.getConnectorKind()) == null) {
            listeners = TaskJobFactory.loadTaskJobListeners(connector.getConnectorKind());
            taskJobListeners.put(connector.getConnectorKind(), listeners);
        }
        listeners = new ArrayList<TaskJobListener>();
        listeners.addAll((Collection<TaskJobListener>)taskJobListeners.get(ALL_CONNECTORS));
        listeners.addAll((Collection<TaskJobListener>)taskJobListeners.get(connector.getConnectorKind()));
        return listeners;
    }

    protected static List<TaskJobListener> loadTaskJobListeners(String connectorKind) {
        ExtensionPointReader reader = new ExtensionPointReader("org.eclipse.mylyn.tasks.core", "taskJobListeners", "listener", TaskJobListener.class, "connectorKind", connectorKind);
        reader.read();
        return reader.getItems();
    }

    public TaskJobFactory(TaskList taskList, TaskDataManager taskDataManager, IRepositoryManager repositoryManager, IRepositoryModel tasksModel) {
        this.taskList = taskList;
        this.taskDataManager = taskDataManager;
        this.repositoryManager = repositoryManager;
        this.tasksModel = tasksModel;
    }

    public SynchronizationJob createSynchronizeTasksJob(AbstractRepositoryConnector connector, Set<ITask> tasks) {
        SynchronizeTasksJob job = new SynchronizeTasksJob(this.taskList, this.taskDataManager, this.tasksModel, connector, this.repositoryManager, tasks);
        job.setPriority(30);
        return job;
    }

    @Override
    public SynchronizationJob createSynchronizeTasksJob(AbstractRepositoryConnector connector, TaskRepository taskRepository, Set<ITask> tasks) {
        SynchronizeTasksJob job = new SynchronizeTasksJob(this.taskList, this.taskDataManager, this.tasksModel, connector, taskRepository, tasks);
        job.setPriority(30);
        return job;
    }

    @Override
    public SynchronizationJob createSynchronizeQueriesJob(AbstractRepositoryConnector connector, TaskRepository repository, Set<RepositoryQuery> queries) {
        SynchronizeQueriesJob job = new SynchronizeQueriesJob(this.taskList, this.taskDataManager, this.tasksModel, connector, repository, queries);
        job.setPriority(50);
        return job;
    }

    @Override
    public SynchronizationJob createSynchronizeRepositoriesJob(Set<TaskRepository> repositories) {
        SynchronizeRepositoriesJob job = new SynchronizeRepositoriesJob(this.taskList, this.taskDataManager, this.tasksModel, this.repositoryManager);
        job.setRepositories(repositories);
        job.setPriority(50);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                TaskJobFactory.this.taskList.notifyElementsChanged(null);
            }
        });
        return job;
    }

    @Override
    public SubmitJob createSubmitTaskJob(AbstractRepositoryConnector connector, TaskRepository taskRepository, final ITask task, TaskData taskData, Set<TaskAttribute> oldAttributes) {
        SubmitTaskJob job = new SubmitTaskJob(this.taskDataManager, connector, taskRepository, task, taskData, oldAttributes, TaskJobFactory.getTaskJobListeners(connector));
        job.setPriority(10);
        job.setUser(true);
        try {
            this.taskList.run(new ITaskListRunnable(){

                @Override
                public void execute(IProgressMonitor monitor) throws CoreException {
                    ((AbstractTask)task).setSynchronizing(true);
                }
            });
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Unexpected error", (Throwable)e));
        }
        this.taskList.notifySynchronizationStateChanged(task);
        return job;
    }

    @Override
    public TaskJob createUpdateRepositoryConfigurationJob(AbstractRepositoryConnector connector, TaskRepository taskRepository, ITask task) {
        UpdateRepositoryConfigurationJob updateJob = new UpdateRepositoryConfigurationJob(Messages.TaskJobFactory_Refreshing_repository_configuration, taskRepository, connector);
        updateJob.setPriority(10);
        updateJob.setRule(new ITasksCoreConstants.ObjectSchedulingRule((Object)taskRepository));
        updateJob.setUser(true);
        return updateJob;
    }

    @Override
    @Deprecated
    public TaskJob createUpdateRepositoryConfigurationJob(AbstractRepositoryConnector connector, TaskRepository taskRepository) {
        return this.createUpdateRepositoryConfigurationJob(connector, taskRepository, null);
    }

    @Override
    public SubmitJob createSubmitTaskAttachmentJob(AbstractRepositoryConnector connector, TaskRepository taskRepository, final ITask task, AbstractTaskAttachmentSource source, String comment, TaskAttribute attachmentAttribute) {
        SubmitTaskAttachmentJob job = new SubmitTaskAttachmentJob(this.taskDataManager, connector, taskRepository, task, source, comment, attachmentAttribute);
        job.setPriority(10);
        try {
            this.taskList.run(new ITaskListRunnable(){

                @Override
                public void execute(IProgressMonitor monitor) throws CoreException {
                    ((AbstractTask)task).setSynchronizing(true);
                }
            });
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Unexpected error", (Throwable)e));
        }
        this.taskList.notifySynchronizationStateChanged(task);
        job.setUser(true);
        return job;
    }
}

