/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.service.Messages;
import org.eclipse.epp.internal.mpc.core.service.xml.Unmarshaller;
import org.eclipse.epp.mpc.core.service.IMarketplaceUnmarshaller;
import org.eclipse.epp.mpc.core.service.UnmarshalException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceUnmarshaller
implements IMarketplaceUnmarshaller {
    @Override
    public <T> T unmarshal(InputStream in, Class<T> type, IProgressMonitor monitor) throws IOException, UnmarshalException {
        XMLReader xmlReader;
        Unmarshaller unmarshaller = new Unmarshaller();
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        try {
            xmlReader = parserFactory.newSAXParser().getXMLReader();
        }
        catch (Exception e1) {
            throw new IllegalStateException(e1);
        }
        xmlReader.setContentHandler(unmarshaller);
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(in), "UTF-8");
        try {
            xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            throw new UnmarshalException(this.createErrorStatus(e.getMessage(), null));
        }
        Object model = unmarshaller.getModel();
        if (model == null) {
            throw new IllegalStateException();
        }
        try {
            return type.cast(model);
        }
        catch (Exception exception) {
            String message = NLS.bind((String)Messages.DefaultMarketplaceService_unexpectedResponseContent, (Object)model.getClass().getSimpleName());
            throw new UnmarshalException(this.createErrorStatus(message, null));
        }
    }

    protected IStatus createErrorStatus(String message, Throwable t) {
        return new Status(4, "org.eclipse.epp.mpc.core", 0, message, t);
    }
}

