/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.ui;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.junit4.ui.util.IResourcesSetupUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractWorkbenchTest
extends Assert {
    @Before
    public void setUp() throws Exception {
        this.closeWelcomePage();
        this.closeEditors();
        IResourcesSetupUtil.cleanWorkspace();
        IResourcesSetupUtil.waitForAutoBuild();
    }

    @After
    public void tearDown() throws Exception {
        this.closeEditors();
        IResourcesSetupUtil.cleanWorkspace();
        IResourcesSetupUtil.waitForAutoBuild();
    }

    protected void closeEditors() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
    }

    protected void closeWelcomePage() throws InterruptedException {
        if (PlatformUI.getWorkbench().getIntroManager().getIntro() != null) {
            PlatformUI.getWorkbench().getIntroManager().closeIntro(PlatformUI.getWorkbench().getIntroManager().getIntro());
        }
    }

    protected void sleep(long i) throws InterruptedException {
        Display displ = Display.getCurrent();
        if (displ != null) {
            long timeToGo = System.currentTimeMillis() + i;
            while (System.currentTimeMillis() < timeToGo) {
                if (displ.readAndDispatch()) continue;
                displ.sleep();
            }
            displ.update();
        } else {
            Thread.sleep(i);
        }
    }

    protected IWorkbenchPage getActivePage() {
        return this.getWorkbenchWindow().getActivePage();
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return this.getWorkbench().getActiveWorkbenchWindow();
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }
}

