/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.macro;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.macro.ActiveAnnotationContexts;
import org.eclipse.xtend.core.macro.AnnotationProcessor;
import org.eclipse.xtend.core.macro.declaration.CompilationUnitImpl;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class ActiveAnnotationContext {
    private final List<XtendAnnotationTarget> annotatedSourceElements = CollectionLiterals.newArrayList((Object[])new XtendAnnotationTarget[0]);
    private Object processorInstance;
    private CompilationUnitImpl compilationUnit;

    public void handleProcessingError(Resource resource, Throwable t) {
        try {
            if (t instanceof VirtualMachineError) {
                throw t;
            }
            ActiveAnnotationContexts.AnnotationCallback _lastPhase = this.compilationUnit.getLastPhase();
            boolean _equals = Objects.equal((Object)((Object)_lastPhase), (Object)((Object)ActiveAnnotationContexts.AnnotationCallback.GENERATION));
            if (_equals) {
                Throwables.propagateIfPossible((Throwable)t);
                String _messageWithoutStackTrace = this.getMessageWithoutStackTrace(t);
                throw new RuntimeException(_messageWithoutStackTrace, t);
            }
            String msg = this.getMessageWithStackTrace(t);
            EList errors = resource.getErrors();
            List<XtendAnnotationTarget> sourceElements = this.getAnnotatedSourceElements();
            for (EObject eObject : sourceElements) {
                boolean _matched = false;
                if (!_matched && eObject instanceof XtendAnnotationTarget) {
                    _matched = true;
                    EList<XAnnotation> annotations = ((XtendAnnotationTarget)eObject).getAnnotations();
                    EObject _xifexpression = null;
                    boolean _isEmpty = annotations.isEmpty();
                    _xifexpression = _isEmpty ? eObject : (EObject)IterableExtensions.head(annotations);
                    EObjectDiagnosticImpl _eObjectDiagnosticImpl = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtend.core.validation.IssueCodes.processing_error", msg, _xifexpression, null, -1, null);
                    errors.add((Object)_eObjectDiagnosticImpl);
                }
                if (_matched) continue;
                EObjectDiagnosticImpl _eObjectDiagnosticImpl = new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtend.core.validation.IssueCodes.processing_error", msg, eObject, null, -1, null);
                errors.add((Object)_eObjectDiagnosticImpl);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public String getMessageWithoutStackTrace(Throwable t) {
        String _xifexpression = null;
        boolean _and = false;
        if (!(t instanceof IncompatibleClassChangeError)) {
            _and = false;
        } else {
            boolean _contains;
            String _message = t.getMessage();
            _and = _contains = _message.contains("org.eclipse.xtend.lib.macro");
        }
        _xifexpression = _and ? "An active annotation used in this file was compiled against a different version of Xtend than the one that is currently installed." : "Error during annotation processing:";
        return _xifexpression;
    }

    public String getMessageWithStackTrace(final Throwable t) {
        Functions.Function1<Throwable, String> _function = new Functions.Function1<Throwable, String>(){

            public String apply(Throwable it) {
                String _xblockexpression = null;
                StringWriter _stringWriter = new StringWriter();
                Procedures.Procedure1<StringWriter> _function = new Procedures.Procedure1<StringWriter>(){

                    public void apply(StringWriter it) {
                        PrintWriter _printWriter = new PrintWriter(it);
                        Procedures.Procedure1<PrintWriter> _function = new Procedures.Procedure1<PrintWriter>(){

                            public void apply(PrintWriter it) {
                                String _messageWithoutStackTrace = ActiveAnnotationContext.this.getMessageWithoutStackTrace(t);
                                it.println(_messageWithoutStackTrace);
                                t.printStackTrace(it);
                                it.flush();
                            }
                        };
                        ObjectExtensions.operator_doubleArrow((Object)_printWriter, (Procedures.Procedure1)_function);
                    }
                };
                StringWriter writer = (StringWriter)ObjectExtensions.operator_doubleArrow((Object)_stringWriter, (Procedures.Procedure1)_function);
                _xblockexpression = writer.toString();
                return _xblockexpression;
            }
        };
        return this.getMessageWithReducedStackTrace(t, (Functions.Function1<? super Throwable, ? extends String>)_function);
    }

    public String getMessageWithReducedStackTrace(Throwable t, Functions.Function1<? super Throwable, ? extends String> getMessage) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        ArrayList reducedStackTrace = CollectionLiterals.newArrayList((Object[])new StackTraceElement[0]);
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            String _name;
            StackTraceElement it = stackTraceElementArray[n2];
            String _className = it.getClassName();
            boolean _contains = _className.contains(_name = AnnotationProcessor.class.getName());
            if (_contains) {
                try {
                    t.setStackTrace((StackTraceElement[])Conversions.unwrapArray((Object)reducedStackTrace, StackTraceElement.class));
                    String string = (String)getMessage.apply((Object)t);
                    return string;
                }
                finally {
                    t.setStackTrace(stackTrace);
                }
            }
            reducedStackTrace.add(it);
            ++n2;
        }
        return (String)getMessage.apply((Object)t);
    }

    @Pure
    public List<XtendAnnotationTarget> getAnnotatedSourceElements() {
        return this.annotatedSourceElements;
    }

    @Pure
    public Object getProcessorInstance() {
        return this.processorInstance;
    }

    public void setProcessorInstance(Object processorInstance) {
        this.processorInstance = processorInstance;
    }

    @Pure
    public CompilationUnitImpl getCompilationUnit() {
        return this.compilationUnit;
    }

    public void setCompilationUnit(CompilationUnitImpl compilationUnit) {
        this.compilationUnit = compilationUnit;
    }
}

