/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.testing.AbstractEditorTest;

@Beta
public class AbstractCodeMiningTest
extends AbstractEditorTest {
    @Inject
    protected FileExtensionProvider fileExtensionProvider;
    @Inject
    protected ICodeMiningProvider codeMiningProvider;

    public void testCodeMining(CharSequence initialText, String expected) {
        IFile dslFile = this.dslFile(initialText);
        XtextEditor editor = this.openEditor(dslFile);
        this.codeMiningsArePresent(editor, expected);
    }

    @Override
    protected XtextEditor openEditor(IFile dslFile) {
        try {
            XtextEditor editor = super.openEditor(dslFile);
            AbstractCodeMiningTest.assertNotNull((Object)editor);
            return editor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void codeMiningsArePresent(XtextEditor editor, String expected) {
        String actual = this.insertCodeMinings(editor);
        AbstractCodeMiningTest.assertEquals((Object)expected, (Object)actual);
    }

    protected String insertCodeMinings(XtextEditor editor) {
        List codeMinings;
        ISourceViewer viewer = editor.getInternalSourceViewer();
        String text = editor.getDocument().get();
        StringBuilder sb = new StringBuilder();
        try {
            codeMinings = (List)this.codeMiningProvider.provideCodeMinings((ITextViewer)viewer, (IProgressMonitor)new NullProgressMonitor()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        for (ICodeMining codeMining : codeMinings) {
            try {
                codeMining.resolve((ITextViewer)viewer, (IProgressMonitor)new NullProgressMonitor()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
            AbstractCodeMiningTest.assertTrue((String)"CodeMining is not resolved!", (boolean)codeMining.isResolved());
        }
        codeMinings.sort((cm1, cm2) -> cm1.getPosition().getOffset() - cm2.getPosition().getOffset());
        int currentOffset = 0;
        int i = 0;
        while (i < codeMinings.size()) {
            ICodeMining codeMining = (ICodeMining)codeMinings.get(i);
            int codeMiningOffset = codeMining.getPosition().getOffset();
            List<ICodeMining> codeMiningsOnTheSameOffset = this.getCodeMiningsByOffset(codeMinings, codeMiningOffset);
            String codeMiningsText = this.getCodeMiningsText(codeMiningsOnTheSameOffset);
            sb.append(String.valueOf(text.substring(currentOffset, codeMiningOffset)) + codeMiningsText);
            currentOffset = codeMiningOffset;
            if (this.containsLineHeaderCodeMining(codeMiningsOnTheSameOffset)) {
                sb.append(System.lineSeparator());
                --currentOffset;
            }
            i = this.getLastCodeMiningOnOffset(codeMinings, codeMiningOffset);
            ++i;
        }
        sb.append(text.substring(currentOffset));
        return sb.toString();
    }

    protected List<ICodeMining> getCodeMiningsByOffset(List<? extends ICodeMining> codeMinings, int offset) {
        ArrayList<ICodeMining> result = new ArrayList<ICodeMining>();
        for (ICodeMining iCodeMining : codeMinings) {
            int codeMiningOffset = iCodeMining.getPosition().getOffset();
            if (codeMiningOffset != offset) continue;
            result.add(iCodeMining);
        }
        return result;
    }

    protected String getCodeMiningsText(List<? extends ICodeMining> codeMinings) {
        StringBuilder result = new StringBuilder();
        int count = 0;
        for (ICodeMining iCodeMining : codeMinings) {
            String codeMiningLabel = iCodeMining.getLabel();
            if (codeMiningLabel != null) {
                if (count != 0) {
                    result.append(" | ");
                }
                result.append(codeMiningLabel);
            }
            ++count;
        }
        return result.toString();
    }

    protected boolean containsLineHeaderCodeMining(List<ICodeMining> codeMinings) {
        for (ICodeMining codeMining : codeMinings) {
            if (!(codeMining instanceof LineHeaderCodeMining)) continue;
            return true;
        }
        return false;
    }

    protected int getLastCodeMiningOnOffset(List<? extends ICodeMining> codeMinings, int offset) {
        int i = 0;
        while (i < codeMinings.size()) {
            ICodeMining codeMining = codeMinings.get(i);
            if (codeMining.getPosition().getOffset() > offset) {
                return i - 1;
            }
            ++i;
        }
        return codeMinings.size();
    }

    protected IFile dslFile(CharSequence content) {
        return this.dslFile(this.getProjectName(), this.getFileName(), this.getFileExtension(), content);
    }

    protected String getProjectName() {
        return "CodeMiningTestProject";
    }

    protected String getFileName() {
        return "codeMining";
    }

    protected String getFileExtension() {
        return this.fileExtensionProvider.getPrimaryFileExtension();
    }
}

