/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.semanticHighlight;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SemanticHighlightingCapabilities;
import org.eclipse.lsp4j.SemanticHighlightingInformation;
import org.eclipse.lsp4j.SemanticHighlightingParams;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.util.SemanticHighlightingTokens;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.MergingHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.semanticHighlight.ISemanticHighlightingStyleToTokenMapper;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Log
public class SemanticHighlightingRegistry {
    public static final String UNKNOWN_SCOPE = "unknown.xtext";
    public static final List<String> UNKNOWN_SCOPES = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"unknown.xtext"}));
    @Inject
    @Extension
    private UriExtensions _uriExtensions;
    protected BiMap<Integer, List<String>> scopes;
    protected LanguageClient client;
    private static final Logger LOG = Logger.getLogger(SemanticHighlightingRegistry.class);

    public void initialize(Iterable<? extends IResourceServiceProvider> allLanguages, ClientCapabilities capabilities, LanguageClient client) {
        Preconditions.checkState((this.client == null ? 1 : 0) != 0, (Object)"Already initialized.");
        Boolean _elvis = null;
        TextDocumentClientCapabilities _textDocument = null;
        if (capabilities != null) {
            _textDocument = capabilities.getTextDocument();
        }
        SemanticHighlightingCapabilities _semanticHighlightingCapabilities = null;
        if (_textDocument != null) {
            _semanticHighlightingCapabilities = _textDocument.getSemanticHighlightingCapabilities();
        }
        Boolean _semanticHighlighting = null;
        if (_semanticHighlightingCapabilities != null) {
            _semanticHighlighting = _semanticHighlightingCapabilities.getSemanticHighlighting();
        }
        _elvis = _semanticHighlighting != null ? _semanticHighlighting : Boolean.valueOf(false);
        Boolean enabled = _elvis;
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        if (enabled.booleanValue()) {
            Functions.Function1 _function = it -> (ISemanticHighlightingStyleToTokenMapper)it.get(ISemanticHighlightingStyleToTokenMapper.class);
            Functions.Function1 _function_1 = mapper -> {
                Functions.Function1 _function_2 = styleId -> mapper.toScopes((String)styleId);
                return IterableExtensions.map(mapper.getAllStyleIds(), (Functions.Function1)_function_2);
            };
            Functions.Function1 _function_2 = it -> {
                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)it);
                return !_isNullOrEmpty;
            };
            Procedures.Procedure2 _function_3 = (scope, index) -> builder.put(index, scope);
            IterableExtensions.forEach((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(allLanguages, (Functions.Function1)_function)), (Functions.Function1)_function_1)), (Functions.Function1)_function_2)), (Procedures.Procedure2)_function_3);
        }
        this.scopes = builder.build();
        this.client = client;
    }

    public List<String> getScopes(int scopeIndex) {
        this.checkInitialized();
        return (List)this.scopes.getOrDefault((Object)scopeIndex, UNKNOWN_SCOPES);
    }

    public int getIndex(List<String> scopes) {
        this.checkInitialized();
        boolean _isNullOrUnknown = this.isNullOrUnknown(scopes);
        if (_isNullOrUnknown) {
            return -1;
        }
        Integer index = (Integer)this.scopes.inverse().get(scopes);
        Integer _xifexpression = null;
        _xifexpression = index == null ? Integer.valueOf(-1) : index;
        return _xifexpression;
    }

    public List<List<String>> getAllScopes() {
        this.checkInitialized();
        ImmutableList.Builder builder = ImmutableList.builder();
        Consumer<Integer> _function = it -> {
            List _get = (List)this.scopes.get(it);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No scopes are available for index: ");
            _builder.append(it);
            builder.add(Preconditions.checkNotNull((Object)_get, (Object)_builder));
        };
        this.scopes.keySet().forEach(_function);
        return builder.build();
    }

    public void update(ILanguageServerAccess.Context context) {
        boolean _not_1;
        boolean _not;
        this.checkInitialized();
        Resource _resource = context.getResource();
        boolean bl = _not = !(_resource instanceof XtextResource);
        if (_not) {
            return;
        }
        boolean _isDocumentOpen = context.isDocumentOpen();
        boolean bl2 = _not_1 = !_isDocumentOpen;
        if (_not_1) {
            return;
        }
        Resource _resource_1 = context.getResource();
        XtextResource resource = (XtextResource)_resource_1;
        IResourceServiceProvider _resourceServiceProvider = resource.getResourceServiceProvider();
        ISemanticHighlightingCalculator _get = null;
        if (_resourceServiceProvider != null) {
            _get = (ISemanticHighlightingCalculator)_resourceServiceProvider.get(ISemanticHighlightingCalculator.class);
        }
        ISemanticHighlightingCalculator calculator = _get;
        IResourceServiceProvider _resourceServiceProvider_1 = resource.getResourceServiceProvider();
        ISemanticHighlightingStyleToTokenMapper _get_1 = null;
        if (_resourceServiceProvider_1 != null) {
            _get_1 = (ISemanticHighlightingStyleToTokenMapper)_resourceServiceProvider_1.get(ISemanticHighlightingStyleToTokenMapper.class);
        }
        ISemanticHighlightingStyleToTokenMapper mapper = _get_1;
        if (calculator == null || mapper == null) {
            return;
        }
        Document document = context.getDocument();
        MergingHighlightedPositionAcceptor acceptor = new MergingHighlightedPositionAcceptor(calculator);
        calculator.provideHighlightingFor(resource, acceptor, CancelIndicator.NullImpl);
        Functions.Function1 _function = position -> {
            Functions.Function1 _function_1 = id -> {
                Position start = document.getPosition(position.getOffset());
                int _offset = position.getOffset();
                int _length = position.getLength();
                int _plus = _offset + _length;
                Position end = document.getPosition(_plus);
                int scope = this.getIndex(mapper.toScopes((String)id));
                return new HighlightedRange(start, end, scope);
            };
            return ListExtensions.map((List)((List)Conversions.doWrapArray((Object)position.getIds())), (Functions.Function1)_function_1);
        };
        Iterable ranges = Iterables.concat((Iterable)ListExtensions.map(acceptor.getPositions(), (Functions.Function1)_function));
        List<SemanticHighlightingInformation> lines = this.toSemanticHighlightingInformation(ranges, document);
        VersionedTextDocumentIdentifier textDocument = this.toVersionedTextDocumentIdentifier(context);
        SemanticHighlightingParams _semanticHighlightingParams = new SemanticHighlightingParams(textDocument, lines);
        this.notifyClient(_semanticHighlightingParams);
    }

    protected List<SemanticHighlightingInformation> toSemanticHighlightingInformation(Iterable<? extends HighlightedRange> ranges, Document document) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        Functions.Function1 _function = it -> {
            Position _end;
            Position _start = it.getStart();
            return !Objects.equal((Object)_start, (Object)(_end = it.getEnd()));
        };
        Consumer<HighlightedRange> _function_1 = it -> {
            int endLine;
            int startLine = it.getStart().getLine();
            if (startLine == (endLine = it.getEnd().getLine())) {
                int _character = it.getEnd().getCharacter();
                int _character_1 = it.getStart().getCharacter();
                int length = _character - _character_1;
                int _character_2 = it.getStart().getCharacter();
                SemanticHighlightingTokens.Token _token = new SemanticHighlightingTokens.Token(_character_2, length, ((HighlightedRange)it).scope);
                builder.put((Object)startLine, (Object)_token);
            } else {
                String startLineContent = document.getLineContent(startLine);
                int _length = startLineContent.length();
                int _character_3 = it.getStart().getCharacter();
                int startLength = _length - _character_3;
                int _character_4 = it.getStart().getCharacter();
                SemanticHighlightingTokens.Token _token_1 = new SemanticHighlightingTokens.Token(_character_4, startLength, ((HighlightedRange)it).scope);
                builder.put((Object)startLine, (Object)_token_1);
                for (int line = startLine + 1; line < endLine; ++line) {
                    String lineContent = document.getLineContent(line);
                    int _length_1 = lineContent.length();
                    SemanticHighlightingTokens.Token _token_2 = new SemanticHighlightingTokens.Token(0, _length_1, ((HighlightedRange)it).scope);
                    builder.put((Object)line, (Object)_token_2);
                }
                int _character_5 = it.getEnd().getCharacter();
                SemanticHighlightingTokens.Token _token_2 = new SemanticHighlightingTokens.Token(0, _character_5, ((HighlightedRange)it).scope);
                builder.put((Object)endLine, (Object)_token_2);
            }
        };
        IterableExtensions.filter(ranges, (Functions.Function1)_function).forEach(_function_1);
        Functions.Function1 _function_2 = it -> {
            SemanticHighlightingInformation _xblockexpression = null;
            Integer line = (Integer)it.getKey();
            Collection tokens = (Collection)it.getValue();
            String _encode = SemanticHighlightingTokens.encode((Iterable)tokens);
            _xblockexpression = new SemanticHighlightingInformation(line.intValue(), _encode);
            return _xblockexpression;
        };
        return this.appendEmptyLineTokens(IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)builder.build().asMap().entrySet(), (Functions.Function1)_function_2)), document);
    }

    protected List<SemanticHighlightingInformation> appendEmptyLineTokens(List<SemanticHighlightingInformation> infos, Document document) {
        int lineCount = document.getLineCount();
        Function _function = it -> it.getLine();
        HashMap tokens = Maps.newHashMap((Map)Maps.uniqueIndex(infos, (Function)_function));
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, lineCount, true);
        for (Integer i : _doubleDotLessThan) {
            boolean _containsKey = tokens.containsKey(i);
            boolean _not = !_containsKey;
            if (!_not) continue;
            SemanticHighlightingInformation _semanticHighlightingInformation = new SemanticHighlightingInformation(i.intValue(), null);
            tokens.put(i, _semanticHighlightingInformation);
        }
        return IterableExtensions.toList(tokens.values());
    }

    protected VersionedTextDocumentIdentifier toVersionedTextDocumentIdentifier(ILanguageServerAccess.Context context) {
        VersionedTextDocumentIdentifier _versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier();
        Procedures.Procedure1 _function = it -> {
            it.setUri(this._uriExtensions.toUriString(context.getResource().getURI()));
            it.setVersion(context.getDocument().getVersion());
        };
        return (VersionedTextDocumentIdentifier)ObjectExtensions.operator_doubleArrow((Object)_versionedTextDocumentIdentifier, (Procedures.Procedure1)_function);
    }

    protected void notifyClient(SemanticHighlightingParams params) {
        this.client.semanticHighlighting(params);
    }

    protected void checkInitialized() {
        Preconditions.checkState((this.client != null ? 1 : 0) != 0, (Object)"Not initialized.");
    }

    protected boolean isNullOrUnknown(List<String> nullable) {
        return nullable == null || Objects.equal(nullable, UNKNOWN_SCOPES);
    }

    @Data
    public static class HighlightedRange
    extends Range {
        private final int scope;

        public HighlightedRange(Position start, Position end, int scope) {
            super(start, end);
            this.scope = scope;
        }

        @Pure
        public int hashCode() {
            return 31 * super.hashCode() + this.scope;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            if (!super.equals(obj)) {
                return false;
            }
            HighlightedRange other = (HighlightedRange)((Object)obj);
            return other.scope == this.scope;
        }

        @Pure
        public String toString() {
            return new ToStringBuilder((Object)this).addAllFields().toString();
        }

        @Pure
        public int getScope() {
            return this.scope;
        }
    }
}

