/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.refactoring2.TryWithResource;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;

@FinalFieldsConstructor
public class ReplaceFileContentChange
extends ResourceChange {
    private final IFile file;
    private final byte[] newContents;
    @Accessors
    private String name;

    protected IResource getModifiedResource() {
        return this.file;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        boolean _not;
        RefactoringStatus result = new RefactoringStatus();
        boolean _exists = this.file.exists();
        boolean bl = _not = !_exists;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("File '");
            IPath _fullPath = this.file.getFullPath();
            _builder.append((Object)_fullPath);
            _builder.append("' does not exist");
            result.addFatalError(_builder.toString());
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ReplaceFileContentChange _xblockexpression = null;
        byte[] oldContents = this.getOldContents();
        ByteArrayInputStream newContentsIS = new ByteArrayInputStream(this.newContents);
        Functions.Function0 _function = () -> {
            try {
                this.file.setContents((InputStream)newContentsIS, true, true, pm);
                return new ReplaceFileContentChange(this.file, oldContents);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        _xblockexpression = (ReplaceFileContentChange)((Object)TryWithResource.tryWith((Closeable)newContentsIS, _function));
        return _xblockexpression;
    }

    protected byte[] getOldContents() {
        byte[] _xblockexpression = null;
        ByteArrayOutputStream oldContentsBAOS = new ByteArrayOutputStream();
        Functions.Function0 _function = () -> {
            try {
                byte[] _xblockexpression_1 = null;
                InputStream oldContentsIS = this.file.getContents();
                Functions.Function0 _function_1 = () -> {
                    try {
                        int readBytes = 0;
                        byte[] buffer = new byte[4096];
                        while ((readBytes = oldContentsIS.read(buffer)) != -1) {
                            oldContentsBAOS.write(buffer, 0, readBytes);
                        }
                        return oldContentsBAOS.toByteArray();
                    }
                    catch (Throwable _e) {
                        throw Exceptions.sneakyThrow((Throwable)_e);
                    }
                };
                _xblockexpression_1 = (byte[])TryWithResource.tryWith((Closeable)oldContentsIS, _function_1);
                return _xblockexpression_1;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        _xblockexpression = (byte[])TryWithResource.tryWith((Closeable)oldContentsBAOS, _function);
        return _xblockexpression;
    }

    public ReplaceFileContentChange(IFile file, byte[] newContents) {
        this.file = file;
        this.newContents = newContents;
    }

    @Pure
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

