/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.mwe.utils.GenModelHelper;
import org.eclipse.emf.mwe.utils.StandaloneSetup;
import org.eclipse.xtext.ecore.EcoreSupportStandaloneSetup;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Log
public class XtextGeneratorResourceSetInitializer {
    private static final Logger LOG = Logger.getLogger(XtextGeneratorResourceSetInitializer.class);

    public void initialize(final ResourceSet resourceSet, List<String> referencedResources) {
        StandaloneSetup delegate = new StandaloneSetup();
        delegate.setResourceSet(resourceSet);
        EPackage.Registry _packageRegistry = resourceSet.getPackageRegistry();
        _packageRegistry.put((Object)"http://www.eclipse.org/emf/2002/Ecore", (Object)EcorePackage.eINSTANCE);
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String it) {
                XtextGeneratorResourceSetInitializer.this.loadResource(it, resourceSet);
            }
        };
        IterableExtensions.forEach(referencedResources, (Procedures.Procedure1)_function);
        this.registerGenModels(resourceSet);
        this.registerEPackages(resourceSet);
    }

    private void loadResource(String loadedResource, ResourceSet resourceSet) {
        URI loadedResourceUri = URI.createURI((String)loadedResource);
        this.ensureResourceCanBeLoaded(loadedResourceUri, resourceSet);
        resourceSet.getResource(loadedResourceUri, true);
    }

    private void ensureResourceCanBeLoaded(URI loadedResource, ResourceSet resourceSet) {
        String _fileExtension = loadedResource.fileExtension();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_fileExtension, (Object)"genmodel")) {
            _matched = true;
            GenModelPackage.eINSTANCE.getEFactoryInstance();
            IResourceServiceProvider resourceServiceProvider = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResource);
            if (resourceServiceProvider == null) {
                try {
                    Class<?> genModelSupport = Class.forName("org.eclipse.emf.codegen.ecore.xtext.GenModelSupport");
                    Object instance = genModelSupport.newInstance();
                    Method _declaredMethod = genModelSupport.getDeclaredMethod("createInjectorAndDoEMFRegistration", new Class[0]);
                    _declaredMethod.invoke(instance, new Object[0]);
                }
                catch (Throwable _t) {
                    if (_t instanceof ClassNotFoundException) {
                        ClassNotFoundException cfr_ignored_0 = (ClassNotFoundException)_t;
                        LOG.debug((Object)"org.eclipse.emf.codegen.ecore.xtext.GenModelSupport not found, GenModels will not be indexed");
                    }
                    if (_t instanceof Exception) {
                        Exception e_1 = (Exception)_t;
                        LOG.error((Object)"Couldn't initialize GenModel support.", (Throwable)e_1);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
        }
        if (!_matched && Objects.equal((Object)_fileExtension, (Object)"ecore")) {
            _matched = true;
            IResourceServiceProvider resourceServiceProvider_1 = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResource);
            if (resourceServiceProvider_1 == null) {
                EcoreSupportStandaloneSetup.setup();
            }
        }
        if (!_matched && Objects.equal((Object)_fileExtension, (Object)"xcore")) {
            _matched = true;
            IResourceServiceProvider resourceServiceProvider_2 = IResourceServiceProvider.Registry.INSTANCE.getResourceServiceProvider(loadedResource);
            if (resourceServiceProvider_2 == null) {
                try {
                    Class<?> xcore = Class.forName("org.eclipse.emf.ecore.xcore.XcoreStandaloneSetup");
                    Method _declaredMethod_1 = xcore.getDeclaredMethod("doSetup", new Class[0]);
                    _declaredMethod_1.invoke(null, new Object[0]);
                }
                catch (Throwable _t_1) {
                    if (_t_1 instanceof ClassNotFoundException) {
                        ClassNotFoundException e_2 = (ClassNotFoundException)_t_1;
                        LOG.error((Object)"Couldn't initialize Xcore support. Is it on the classpath?");
                        String _message = e_2.getMessage();
                        LOG.debug((Object)_message, (Throwable)e_2);
                    }
                    if (_t_1 instanceof Exception) {
                        Exception e_3 = (Exception)_t_1;
                        LOG.error((Object)"Couldn't initialize Xcore support.", (Throwable)e_3);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t_1);
                }
            }
            URI xcoreLangURI = URI.createPlatformResourceURI((String)"/org.eclipse.emf.ecore.xcore.lib/model/XcoreLang.xcore", (boolean)true);
            try {
                resourceSet.getResource(xcoreLangURI, true);
            }
            catch (Throwable _t_2) {
                if (_t_2 instanceof WrappedException) {
                    WrappedException e_4 = (WrappedException)_t_2;
                    LOG.error((Object)"Could not load XcoreLang.xcore.", (Throwable)e_4);
                    Resource brokenResource = resourceSet.getResource(xcoreLangURI, false);
                    EList _resources = resourceSet.getResources();
                    _resources.remove((Object)brokenResource);
                }
                throw Exceptions.sneakyThrow((Throwable)_t_2);
            }
        }
    }

    private void registerEPackages(ResourceSet resourceSet) {
        Procedures.Procedure1<EPackage> _function = new Procedures.Procedure1<EPackage>(){

            public void apply(EPackage it) {
                XtextGeneratorResourceSetInitializer.this.register(it);
            }
        };
        this.each(resourceSet, EPackage.class, _function);
    }

    private void register(EPackage ePackage) {
        boolean _tripleEquals;
        String _nsURI;
        Resource _eResource = ePackage.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        EPackage.Registry registry = _resourceSet.getPackageRegistry();
        Object _get = registry.get((Object)(_nsURI = ePackage.getNsURI()));
        boolean bl = _tripleEquals = _get == null;
        if (_tripleEquals) {
            String _nsURI_1 = ePackage.getNsURI();
            registry.put((Object)_nsURI_1, (Object)ePackage);
        }
    }

    private void registerGenModels(ResourceSet resourceSet) {
        Procedures.Procedure1<GenModel> _function = new Procedures.Procedure1<GenModel>(){

            public void apply(GenModel it) {
                XtextGeneratorResourceSetInitializer.this.register(it);
            }
        };
        this.each(resourceSet, GenModel.class, _function);
    }

    private void register(GenModel genModel) {
        GenModelHelper _genModelHelper = new GenModelHelper();
        _genModelHelper.registerGenModel(genModel);
    }

    private <Type> void each(ResourceSet resourceSet, Class<Type> type, final Procedures.Procedure1<? super Type> strategy) {
        int i = 0;
        while (i < resourceSet.getResources().size()) {
            EList _resources = resourceSet.getResources();
            Resource resource = (Resource)_resources.get(i);
            EList _contents = resource.getContents();
            Iterable _filter = Iterables.filter((Iterable)_contents, type);
            Procedures.Procedure1 _function = new Procedures.Procedure1<Type>(){

                public void apply(Type it) {
                    strategy.apply(it);
                }
            };
            IterableExtensions.forEach((Iterable)_filter, (Procedures.Procedure1)_function);
            ++i;
        }
    }
}

