/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.util;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.MacroAwareTextBrowseFolderListener;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class IdeaWidgetFactory {
    private static boolean debug = false;

    public JPanel container(Functions.Function1<? super GridBagConstraints, ? extends JComponent> ... children) {
        GridBagLayout layout = new GridBagLayout();
        JPanel flowPanel = new JPanel(layout);
        for (Functions.Function1<? super GridBagConstraints, ? extends JComponent> childAddition : children) {
            GridBagConstraints ld = new GridBagConstraints();
            JComponent _apply = (JComponent)childAddition.apply((Object)ld);
            flowPanel.add((Component)_apply, ld);
        }
        return flowPanel;
    }

    public JCheckBox checkBox(String string) {
        JCheckBox _jCheckBox = new JCheckBox(string);
        Procedures.Procedure1<JCheckBox> _function = new Procedures.Procedure1<JCheckBox>(){

            public void apply(JCheckBox it) {
                if (debug) {
                    it.setBorderPainted(true);
                }
            }
        };
        return (JCheckBox)ObjectExtensions.operator_doubleArrow((Object)_jCheckBox, (Procedures.Procedure1)_function);
    }

    public TwoColumnPanel twoColumnPanel(Functions.Function1<? super TwoColumnPanel, ? extends TwoColumnPanel> additions) {
        TwoColumnPanel _twoColumnPanel = new TwoColumnPanel();
        Procedures.Procedure1<TwoColumnPanel> _function = new Procedures.Procedure1<TwoColumnPanel>(){

            public void apply(TwoColumnPanel it) {
                EmptyBorder _emptyBorder = IdeaWidgetFactory.this.emptyBorder(10);
                it.setBorder(_emptyBorder);
                GridBagLayout _gridBagLayout = new GridBagLayout();
                it.setLayout(_gridBagLayout);
            }
        };
        TwoColumnPanel panel = (TwoColumnPanel)ObjectExtensions.operator_doubleArrow((Object)_twoColumnPanel, (Procedures.Procedure1)_function);
        additions.apply((Object)panel);
        return panel;
    }

    public EmptyBorder emptyBorder(int i) {
        return new EmptyBorder(i, i, i, i);
    }

    public JLabel label(String text) {
        return new JLabel(text);
    }

    public TextFieldWithBrowseButton browseField(Project project) {
        TextFieldWithBrowseButton field = new TextFieldWithBrowseButton();
        FileChooserDescriptor _createSingleFolderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        MacroAwareTextBrowseFolderListener listener = new MacroAwareTextBrowseFolderListener(_createSingleFolderDescriptor, project);
        field.addBrowseFolderListener((TextBrowseFolderListener)listener);
        return field;
    }

    public JBTextField textField() {
        return this.textField("");
    }

    public JBTextField textField(String text) {
        JBTextField jbTextField = new JBTextField(text, 20);
        return jbTextField;
    }

    public ComboBox comboBox(Object ... values) {
        ComboBox cb = new ComboBox(values);
        return cb;
    }

    public void expand(GridBagConstraints it, int dim) {
        if (dim == 3) {
            it.weighty = 1.0;
            it.fill = 3;
        } else if (dim == 2) {
            it.weightx = 1.0;
            it.fill = 2;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void indent(GridBagConstraints it) {
        Insets _insets;
        it.insets = _insets = new Insets(it.insets.top, it.insets.left + 40, it.insets.bottom, it.insets.right);
    }

    public void indentRight(GridBagConstraints it, int size) {
        Insets _insets;
        it.insets = _insets = new Insets(it.insets.top, it.insets.left, it.insets.bottom, it.insets.right + size);
    }

    public SeparatorWithText separator(final String title) {
        SeparatorWithText _separatorWithText = new SeparatorWithText();
        Procedures.Procedure1<SeparatorWithText> _function = new Procedures.Procedure1<SeparatorWithText>(){

            public void apply(SeparatorWithText it) {
                it.setCaption(title);
                it.setCaptionCentered(false);
            }
        };
        SeparatorWithText separator = (SeparatorWithText)ObjectExtensions.operator_doubleArrow((Object)_separatorWithText, (Procedures.Procedure1)_function);
        return separator;
    }

    public static class TwoColumnPanel
    extends JPanel {
        private int rowsAdded = 0;

        public TwoColumnPanel row(TwoColumnPanel host, Functions.Function1<? super GridBagConstraints, ? extends JComponent> col) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = this.rowsAdded++;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.gridwidth = 2;
            gbc.ipady = 4;
            JComponent _apply = (JComponent)col.apply((Object)gbc);
            host.add((Component)_apply, gbc);
            return host;
        }

        public TwoColumnPanel row(TwoColumnPanel host, Functions.Function1<? super GridBagConstraints, ? extends JComponent> col1, Functions.Function1<? super GridBagConstraints, ? extends JComponent> col2) {
            GridBagConstraints _gridBagConstraints;
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = this.rowsAdded;
            gbc.ipady = 4;
            gbc.anchor = 13;
            JComponent _apply = (JComponent)col1.apply((Object)gbc);
            host.add((Component)_apply, gbc);
            gbc = _gridBagConstraints = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = this.rowsAdded++;
            gbc.anchor = 17;
            gbc.fill = 2;
            JComponent _apply_1 = (JComponent)col2.apply((Object)gbc);
            host.add((Component)_apply_1, gbc);
            return host;
        }

        @Override
        public void add(Component comp, Object constraints) {
            super.add(comp, constraints);
            if (comp instanceof JComponent && debug) {
                Border _createLineBorder = BorderFactory.createLineBorder(Color.BLACK);
                ((JComponent)comp).setBorder(_createLineBorder);
            }
        }
    }
}

