/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.nodemodel;

import com.google.common.base.Objects;
import com.google.inject.Singleton;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TypeRef;
import org.eclipse.xtext.idea.nodemodel.IASTNodeAwareNodeModelBuilder;
import org.eclipse.xtext.psi.tree.IGrammarAwareElementType;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;

@Singleton
public class ASTNodeExtension {
    public List<ASTNode> findNodesForFeature(ASTNode node, EStructuralFeature structuralFeature) {
        EClass _eContainingClass = structuralFeature.getEContainingClass();
        ASTNode actualNode = this.findActualNodeFor(node, _eContainingClass);
        if (actualNode instanceof TreeElement) {
            return this.findNodesForFeature((TreeElement)actualNode, structuralFeature);
        }
        return CollectionLiterals.emptyList();
    }

    protected ASTNode findActualNodeFor(ASTNode node, EClass type) {
        if (node == null || type == null) {
            return null;
        }
        ASTNode result = node;
        while (result != null && !((Boolean)ObjectExtensions.operator_elvis((Object)result.getUserData(IASTNodeAwareNodeModelBuilder.HAS_SEMANTIC_ELEMENT_KEY), (Object)false)).booleanValue()) {
            ASTNode _treeParent;
            result = _treeParent = result.getTreeParent();
        }
        EClass actualType = this.getEClass(result);
        boolean _isAssignableFrom = EcoreUtil2.isAssignableFrom((EClass)type, (EClass)actualType);
        if (_isAssignableFrom) {
            return result;
        }
        return null;
    }

    protected List<ASTNode> findNodesForFeature(final TreeElement treeElement, EStructuralFeature structuralFeature) {
        final ArrayList result = CollectionLiterals.newArrayList((Object[])new ASTNode[0]);
        final String featureName = structuralFeature.getName();
        treeElement.acceptTree((TreeElementVisitor)new RecursiveTreeElementWalkingVisitor(){

            protected void visitNode(TreeElement element) {
                Assignment assignment_1;
                if (element instanceof PsiErrorElement) {
                    return;
                }
                if (element == treeElement) {
                    super.visitNode(element);
                    return;
                }
                EObject grammarElement = ASTNodeExtension.this.getGrammarElement((ASTNode)element);
                if (grammarElement instanceof Action) {
                    TreeElement firstChild = element.getFirstChildNode();
                    while (ASTNodeExtension.this.getGrammarElement((ASTNode)firstChild) instanceof Action) {
                        TreeElement _firstChildNode;
                        firstChild = _firstChildNode = firstChild.getFirstChildNode();
                    }
                    EObject _grammarElement = ASTNodeExtension.this.getGrammarElement((ASTNode)firstChild);
                    Assignment assignment = GrammarUtil.containingAssignment((EObject)_grammarElement);
                    boolean _and = false;
                    if (assignment == null) {
                        _and = false;
                    } else {
                        boolean _equals;
                        String _feature = assignment.getFeature();
                        _and = _equals = Objects.equal((Object)featureName, (Object)_feature);
                    }
                    if (_and) {
                        result.add(element);
                    }
                    return;
                }
                if (grammarElement != null && (assignment_1 = GrammarUtil.containingAssignment((EObject)grammarElement)) != null) {
                    String _feature_1 = assignment_1.getFeature();
                    boolean _equals_1 = Objects.equal((Object)featureName, (Object)_feature_1);
                    if (_equals_1) {
                        result.add(element);
                    }
                    return;
                }
                super.visitNode(element);
            }
        });
        return result;
    }

    public EClass getEClass(ASTNode node) {
        EClassifier classifier;
        EObject grammarElement = this.getGrammarElement(node);
        if (grammarElement == null) {
            return null;
        }
        TypeRef _switchResult = null;
        boolean _matched = false;
        if (!_matched && grammarElement instanceof Action) {
            _matched = true;
            _switchResult = ((Action)grammarElement).getType();
        }
        if (!_matched && grammarElement instanceof RuleCall) {
            _matched = true;
            AbstractRule _rule = ((RuleCall)grammarElement).getRule();
            TypeRef _type = null;
            if (_rule != null) {
                _type = _rule.getType();
            }
            _switchResult = _type;
        }
        if (!_matched) {
            AbstractRule _containingRule = GrammarUtil.containingRule((EObject)grammarElement);
            _switchResult = _containingRule.getType();
        }
        TypeRef type = _switchResult;
        EClassifier _classifier = null;
        if (type != null) {
            _classifier = type.getClassifier();
        }
        if ((classifier = _classifier) instanceof EClass) {
            return (EClass)classifier;
        }
        return null;
    }

    public EObject getGrammarElement(ASTNode element) {
        EObject _xblockexpression = null;
        IElementType _elementType = null;
        if (element != null) {
            _elementType = element.getElementType();
        }
        IElementType elementType = _elementType;
        EObject _xifexpression = null;
        if (elementType instanceof IGrammarAwareElementType) {
            _xifexpression = ((IGrammarAwareElementType)elementType).getGrammarElement();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

