/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.annotation;

import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.idea.intentions.IdeaIntentionsProvider;
import org.eclipse.xtext.idea.lang.IXtextLanguage;
import org.eclipse.xtext.idea.util.CancelProgressIndicator;
import org.eclipse.xtext.psi.PsiEObject;
import org.eclipse.xtext.psi.XtextPsiUtils;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class IssueAnnotator
implements Annotator {
    public void annotate(PsiElement element, AnnotationHolder holder) {
        if (!(element instanceof PsiEObject)) {
            return;
        }
        Language language = element.getLanguage();
        if (!(language instanceof IXtextLanguage)) {
            return;
        }
        PsiEObject psiEObject = (PsiEObject)element;
        if (!psiEObject.isRoot()) {
            return;
        }
        VirtualFile file = XtextPsiUtils.findVirtualFile(element);
        if (!FileEditorManager.getInstance((Project)element.getProject()).isFileOpen(file)) {
            return;
        }
        Resource resource = psiEObject.getResource();
        if (resource == null) {
            return;
        }
        IXtextLanguage xtextLanguage = (IXtextLanguage)language;
        IResourceValidator resourceValidator = xtextLanguage.getInstance(IResourceValidator.class);
        IdeaIntentionsProvider intentionsProvider = xtextLanguage.getInstance(IdeaIntentionsProvider.class);
        try {
            for (Issue issue : this.getIssues(resource, resourceValidator)) {
                HighlightSeverity highlightSeverity;
                if (issue.isSyntaxError() || (highlightSeverity = this.getHighlightSeverity(issue.getSeverity())) == null) continue;
                int startOffset = 0;
                int endOffset = 0;
                if (issue.getOffset() != null) {
                    startOffset = issue.getOffset();
                    endOffset = startOffset + issue.getLength();
                }
                Annotation annotation = holder.createAnnotation(highlightSeverity, new TextRange(startOffset, endOffset), issue.getMessage());
                intentionsProvider.registerFixes(annotation, issue);
            }
        }
        catch (OperationCanceledError e) {
            throw e.getWrapped();
        }
    }

    protected List<Issue> getIssues(Resource resource, IResourceValidator resourceValidator) {
        ProgressIndicatorProvider.checkCanceled();
        try {
            return resourceValidator.validate(resource, CheckMode.NORMAL_AND_FAST, (CancelIndicator)new CancelProgressIndicator());
        }
        catch (OperationCanceledError e) {
            throw e.getWrapped();
        }
    }

    protected HighlightSeverity getHighlightSeverity(Severity severity) {
        if (severity == Severity.ERROR) {
            return HighlightSeverity.ERROR;
        }
        if (severity == Severity.WARNING) {
            return HighlightSeverity.WARNING;
        }
        if (severity == Severity.INFO) {
            return HighlightSeverity.INFORMATION;
        }
        return null;
    }
}

