/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.intentions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.idea.config.XtendLibraryConfigurator;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.idea.document.DocumentUtils;
import org.eclipse.xtext.idea.intentions.AbstractIssueIntentionAction;
import org.eclipse.xtext.idea.intentions.IdeaIntentionsProvider;
import org.eclipse.xtext.nodemodel.BidiTreeIterable;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.psi.XtextPsiExtensions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.ide.contentassist.OverrideProposalUtil;
import org.eclipse.xtext.xbase.imports.RewritableImportSection;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedExecutable;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XtendIntentionsProvider
extends IdeaIntentionsProvider {
    @Inject
    private Provider<InsertXtendMethodsIntentionAction> insertXtendMethodsIntentionActionProvider;
    @Inject
    private Provider<InsertSuperConstructorsIntentionAction> insertSuperConstructorsIntentionActionProvider;
    @Inject
    private Provider<AddXtendLibToClassPathIntentionAction> addXtendLibToClassPathIntentionAction;

    public void registerFixes(Annotation anno, final Issue issue) {
        String _code = issue.getCode();
        boolean _equals = Objects.equal((Object)_code, (Object)"org.eclipse.xtend.core.validation.IssueCodes.missing_constructor");
        if (_equals) {
            InsertSuperConstructorsIntentionAction _get = (InsertSuperConstructorsIntentionAction)((Object)this.insertSuperConstructorsIntentionActionProvider.get());
            Procedures.Procedure1<InsertSuperConstructorsIntentionAction> _function = new Procedures.Procedure1<InsertSuperConstructorsIntentionAction>(){

                public void apply(InsertSuperConstructorsIntentionAction it) {
                    it.setIssue(issue);
                }
            };
            InsertSuperConstructorsIntentionAction _doubleArrow = (InsertSuperConstructorsIntentionAction)((Object)ObjectExtensions.operator_doubleArrow((Object)((Object)_get), (Procedures.Procedure1)_function));
            anno.registerFix((IntentionAction)_doubleArrow);
        } else {
            boolean _or = false;
            String _code_1 = issue.getCode();
            boolean _equals_1 = Objects.equal((Object)_code_1, (Object)"org.eclipse.xtend.core.validation.IssueCodes.class_must_be_defined_abstract");
            if (_equals_1) {
                _or = true;
            } else {
                boolean _equals_2;
                String _code_2 = issue.getCode();
                _or = _equals_2 = Objects.equal((Object)_code_2, (Object)"org.eclipse.xtend.core.validation.IssueCodes.anonymous_class_missing_members");
            }
            if (_or) {
                InsertXtendMethodsIntentionAction _get_1 = (InsertXtendMethodsIntentionAction)((Object)this.insertXtendMethodsIntentionActionProvider.get());
                Procedures.Procedure1<InsertXtendMethodsIntentionAction> _function_1 = new Procedures.Procedure1<InsertXtendMethodsIntentionAction>(){

                    public void apply(InsertXtendMethodsIntentionAction it) {
                        it.setIssue(issue);
                    }
                };
                InsertXtendMethodsIntentionAction _doubleArrow_1 = (InsertXtendMethodsIntentionAction)((Object)ObjectExtensions.operator_doubleArrow((Object)((Object)_get_1), (Procedures.Procedure1)_function_1));
                anno.registerFix((IntentionAction)_doubleArrow_1);
            } else {
                String _code_3 = issue.getCode();
                boolean _equals_3 = Objects.equal((Object)_code_3, (Object)"org.eclipse.xtend.core.validation.IssueCodes.xbase_lib_not_on_classpath");
                if (_equals_3) {
                    AddXtendLibToClassPathIntentionAction _get_2 = (AddXtendLibToClassPathIntentionAction)((Object)this.addXtendLibToClassPathIntentionAction.get());
                    Procedures.Procedure1<AddXtendLibToClassPathIntentionAction> _function_2 = new Procedures.Procedure1<AddXtendLibToClassPathIntentionAction>(){

                        public void apply(AddXtendLibToClassPathIntentionAction it) {
                            it.setIssue(issue);
                        }
                    };
                    AddXtendLibToClassPathIntentionAction _doubleArrow_2 = (AddXtendLibToClassPathIntentionAction)((Object)ObjectExtensions.operator_doubleArrow((Object)((Object)_get_2), (Procedures.Procedure1)_function_2));
                    anno.registerFix((IntentionAction)_doubleArrow_2);
                }
            }
        }
    }

    public static class AddXtendLibToClassPathIntentionAction
    extends AbstractIssueIntentionAction {
        @Inject
        private XtendLibraryConfigurator libraryManager;
        public static final String TEXT = "Add Xtend runtime Library";

        public String getText() {
            return TEXT;
        }

        public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
            if (module != null) {
                ModuleRootManager _instance = ModuleRootManager.getInstance((Module)module);
                ModifiableRootModel model = _instance.getModifiableModel();
                this.libraryManager.ensureXtendLibAvailable(model, file);
                model.commit();
            }
        }
    }

    public static class InsertSuperConstructorsIntentionAction
    extends AbstractMemberAddingIntentionAction {
        public static final String TEXT = "Create constructors matching super";

        public String getText() {
            return TEXT;
        }

        @Override
        public String getMembersToBeInserted(final RewritableImportSection importSection, JvmGenericType jvmType) {
            List candidates = this.overrideProposalUtil.getImplementationCandidates((JvmDeclaredType)jvmType, false);
            Iterable constructors = Iterables.filter((Iterable)candidates, IResolvedConstructor.class);
            StringConcatenation _builder = new StringConcatenation();
            _builder.newLine();
            for (IResolvedConstructor candidate : constructors) {
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"new (");
                ArrayList<String> _parameters = this.getParameters((IResolvedExecutable)candidate, importSection);
                String _join = IterableExtensions.join(_parameters, (CharSequence)", ");
                _builder.append((Object)_join, "\t");
                _builder.append((Object)") ");
                JvmConstructor _declaration = candidate.getDeclaration();
                EList _exceptions = _declaration.getExceptions();
                Functions.Function1<JvmTypeReference, CharSequence> _function = new Functions.Function1<JvmTypeReference, CharSequence>(){

                    public CharSequence apply(JvmTypeReference it) {
                        return InsertSuperConstructorsIntentionAction.this._documentUtils.toImportableString(it, importSection);
                    }
                };
                String _join_1 = IterableExtensions.join((Iterable)_exceptions, (CharSequence)"throws ", (CharSequence)", ", (CharSequence)" ", (Functions.Function1)_function);
                _builder.append((Object)_join_1, "\t");
                _builder.append((Object)"{");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"super(");
                JvmConstructor _declaration_1 = candidate.getDeclaration();
                EList _parameters_1 = _declaration_1.getParameters();
                Functions.Function1<JvmFormalParameter, CharSequence> _function_1 = new Functions.Function1<JvmFormalParameter, CharSequence>(){

                    public CharSequence apply(JvmFormalParameter it) {
                        return it.getName();
                    }
                };
                String _join_2 = IterableExtensions.join((Iterable)_parameters_1, (CharSequence)", ", (Functions.Function1)_function_1);
                _builder.append((Object)_join_2, "\t\t");
                _builder.append((Object)")");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            return _builder.toString();
        }
    }

    public static class InsertXtendMethodsIntentionAction
    extends AbstractMemberAddingIntentionAction {
        public static final String TEXT = "Implement methods";

        public String getText() {
            return TEXT;
        }

        @Override
        public String getMembersToBeInserted(final RewritableImportSection importSection, JvmGenericType jvmType) {
            List candidates = this.overrideProposalUtil.getImplementationCandidates((JvmDeclaredType)jvmType, false);
            Iterable _filter = Iterables.filter((Iterable)candidates, IResolvedOperation.class);
            Functions.Function1<IResolvedOperation, Boolean> _function = new Functions.Function1<IResolvedOperation, Boolean>(){

                public Boolean apply(IResolvedOperation it) {
                    JvmOperation _declaration = it.getDeclaration();
                    return _declaration.isAbstract();
                }
            };
            Iterable abstractMethods = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
            StringConcatenation _builder = new StringConcatenation();
            _builder.newLine();
            for (IResolvedOperation candidate : abstractMethods) {
                _builder.append((Object)"\t");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"override ");
                List _typeParameters = candidate.getTypeParameters();
                Functions.Function1<JvmTypeParameter, CharSequence> _function_1 = new Functions.Function1<JvmTypeParameter, CharSequence>(){

                    public CharSequence apply(JvmTypeParameter it) {
                        return it.getName();
                    }
                };
                String _join = IterableExtensions.join((Iterable)_typeParameters, (CharSequence)"<", (CharSequence)",", (CharSequence)"> ", (Functions.Function1)_function_1);
                _builder.append((Object)_join, "\t");
                JvmOperation _declaration = candidate.getDeclaration();
                String _simpleName = _declaration.getSimpleName();
                _builder.append((Object)_simpleName, "\t");
                _builder.append((Object)"(");
                ArrayList<String> _parameters = this.getParameters((IResolvedExecutable)candidate, importSection);
                String _join_1 = IterableExtensions.join(_parameters, (CharSequence)", ");
                _builder.append((Object)_join_1, "\t");
                _builder.append((Object)") ");
                JvmOperation _declaration_1 = candidate.getDeclaration();
                EList _exceptions = _declaration_1.getExceptions();
                Functions.Function1<JvmTypeReference, CharSequence> _function_2 = new Functions.Function1<JvmTypeReference, CharSequence>(){

                    public CharSequence apply(JvmTypeReference it) {
                        return InsertXtendMethodsIntentionAction.this._documentUtils.toImportableString(it, importSection);
                    }
                };
                String _join_2 = IterableExtensions.join((Iterable)_exceptions, (CharSequence)"throws ", (CharSequence)", ", (CharSequence)" ", (Functions.Function1)_function_2);
                _builder.append((Object)_join_2, "\t");
                _builder.append((Object)"{");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"throw new UnsupportedOperationException()");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            return _builder.toString();
        }
    }

    public static abstract class AbstractMemberAddingIntentionAction
    extends AbstractIssueIntentionAction {
        @Inject
        protected OverrideProposalUtil overrideProposalUtil;
        @Inject
        protected RewritableImportSection.Factory importSectionfactory;
        @Inject
        @Extension
        protected XtextPsiExtensions _xtextPsiExtensions;
        @Inject
        protected XtendGrammarAccess grammarAccess;
        @Inject
        protected IJvmModelAssociations jvmModelAssociations;
        @Inject
        @Extension
        protected DocumentUtils _documentUtils;

        public void invoke(Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            Issue _issue = this.getIssue();
            Integer _offset = _issue.getOffset();
            PsiElement psiElement = this._xtextPsiExtensions.findEObjectAssociatedPsiElement((PsiElement)file, _offset.intValue());
            if (psiElement == null) {
                return;
            }
            EObject _findEObject = this._xtextPsiExtensions.findEObject(psiElement);
            XtendTypeDeclaration clazz = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)_findEObject, XtendTypeDeclaration.class);
            if (clazz == null) {
                return;
            }
            EObject jvmType = this.jvmModelAssociations.getPrimaryJvmElement((EObject)clazz);
            PsiDocumentManager docMnr = PsiDocumentManager.getInstance((Project)project);
            if (jvmType instanceof JvmGenericType) {
                int insertOffset = this.findInsertionOffSet(clazz, editor);
                Resource _eResource = clazz.eResource();
                RewritableImportSection importSection = this.importSectionfactory.parse((XtextResource)_eResource);
                String toInsert = this.getMembersToBeInserted(importSection, (JvmGenericType)jvmType);
                Document _document = editor.getDocument();
                _document.insertString(insertOffset, (CharSequence)toInsert);
                Document _document_1 = editor.getDocument();
                docMnr.commitDocument(_document_1);
                Document _document_2 = editor.getDocument();
                docMnr.doPostponedOperationsAndUnblockDocument(_document_2);
                CodeStyleManager _instance = CodeStyleManager.getInstance((Project)project);
                int _length = toInsert.length();
                int _plus = insertOffset + _length;
                TextRange _textRange = new TextRange(insertOffset, _plus);
                _instance.adjustLineIndent(file, _textRange);
                Document _document_3 = editor.getDocument();
                this._documentUtils.updateImportSection(_document_3, importSection);
                Document _document_4 = editor.getDocument();
                docMnr.commitDocument(_document_4);
            }
        }

        public abstract String getMembersToBeInserted(RewritableImportSection var1, JvmGenericType var2);

        protected ArrayList<String> getParameters(IResolvedExecutable executable, RewritableImportSection importSection) {
            ArrayList result = CollectionLiterals.newArrayList((Object[])new String[0]);
            for (int i = 0; i < executable.getDeclaration().getParameters().size(); ++i) {
                StringConcatenation _builder = new StringConcatenation();
                List _resolvedParameterTypes = executable.getResolvedParameterTypes();
                LightweightTypeReference _get = (LightweightTypeReference)_resolvedParameterTypes.get(i);
                String _importableString = this._documentUtils.toImportableString(_get, importSection);
                _builder.append((Object)_importableString, "");
                _builder.append((Object)" ");
                JvmExecutable _declaration = executable.getDeclaration();
                EList _parameters = _declaration.getParameters();
                JvmFormalParameter _get_1 = (JvmFormalParameter)_parameters.get(i);
                String _simpleName = _get_1.getSimpleName();
                _builder.append((Object)_simpleName, "");
                result.add(_builder.toString());
            }
            return result;
        }

        public int findInsertionOffSet(XtendTypeDeclaration class1, Editor editor) {
            boolean _notEquals_1;
            Functions.Function1<INode, Boolean> _function;
            boolean _notEquals;
            EList _members = class1.getMembers();
            XtendMember last = (XtendMember)IterableExtensions.last((Iterable)_members);
            boolean bl = _notEquals = !Objects.equal((Object)last, null);
            if (_notEquals) {
                ICompositeNode n = NodeModelUtils.getNode((EObject)last);
                int _totalOffset = n.getTotalOffset();
                int _totalLength = n.getTotalLength();
                return _totalOffset + _totalLength;
            }
            ICompositeNode n_1 = NodeModelUtils.getNode((EObject)class1);
            BidiTreeIterable _asTreeIterable = n_1.getAsTreeIterable();
            INode openingBracket = (INode)IterableExtensions.findFirst((Iterable)_asTreeIterable, (Functions.Function1)(_function = new Functions.Function1<INode, Boolean>(){

                public Boolean apply(INode it) {
                    String _text = it.getText();
                    return Objects.equal((Object)_text, (Object)"{");
                }
            }));
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)openingBracket, null);
            if (_notEquals_1) {
                int _offset = openingBracket.getOffset();
                return _offset + 1;
            }
            Document _document = editor.getDocument();
            String _text = _document.getText();
            return _text.lastIndexOf("}");
        }
    }
}

