/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.framework;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.eclipse.xtend.core.idea.framework.XtendLibraryPresentationProvider;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.macro.Active;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class XtendLibraryDescription
extends CustomLibraryDescription {
    public static final Set<LibraryKind> LIBRARY_KINDS = IterableExtensions.toSet((Iterable)ListExtensions.map(XtendLibraryDescription.getProviders(), (Functions.Function1)new Functions.Function1<XtendLibraryPresentationProvider, LibraryKind>(){

        public LibraryKind apply(XtendLibraryPresentationProvider it) {
            return it.getKind();
        }
    }));
    public static final String XTEND_LIBRARY_NAME = "Xtend Library";

    public NewLibraryConfiguration createNewLibrary(JComponent parentComponent, VirtualFile contextDirectory) {
        return this.createLibraryDescription();
    }

    public NewLibraryConfiguration createLibraryDescription() {
        List<XtendLibraryPresentationProvider> _providers = XtendLibraryDescription.getProviders();
        XtendLibraryPresentationProvider provider = (XtendLibraryPresentationProvider)((Object)IterableExtensions.head(_providers));
        boolean _equals = Objects.equal((Object)((Object)provider), null);
        if (_equals) {
            return null;
        }
        abstract class __XtendLibraryDescription_1
        extends NewLibraryConfiguration {
            HashMap<OrderRootType, List<String>> roots;

            __XtendLibraryDescription_1(String defaultLibraryName) {
                super(defaultLibraryName);
            }
        }
        return new __XtendLibraryDescription_1(XTEND_LIBRARY_NAME){
            {
                super(x0);
                this.roots = XtendLibraryDescription.this.libraryRoots();
            }

            public void addRoots(final LibraryEditor editor) {
                Procedures.Procedure2<OrderRootType, List<String>> _function = new Procedures.Procedure2<OrderRootType, List<String>>(){

                    public void apply(final OrderRootType k, List<String> v) {
                        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

                            public void apply(String it) {
                                editor.addRoot(it, k);
                            }
                        };
                        IterableExtensions.forEach(v, (Procedures.Procedure1)_function);
                    }
                };
                MapExtensions.forEach((Map)this.roots, (Procedures.Procedure2)_function);
            }
        };
    }

    public Set<? extends LibraryKind> getSuitableLibraryKinds() {
        return LIBRARY_KINDS;
    }

    public HashMap<OrderRootType, List<String>> libraryRoots() {
        List<? extends Class<?>> _detectorClasses = XtendLibraryDescription.getDetectorClasses();
        Functions.Function1 _function = new Functions.Function1<Class<?>, String>(){

            public String apply(Class<?> it) {
                return XtendLibraryDescription.this.getUrlForLibraryRoot(it);
            }
        };
        List _map = ListExtensions.map(_detectorClasses, (Functions.Function1)_function);
        Pair _mappedTo = Pair.of((Object)OrderRootType.CLASSES, (Object)_map);
        return CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo});
    }

    public static List<? extends Class<?>> getDetectorClasses() {
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{Lists.class, ToStringBuilder.class, Active.class, Data.class}));
    }

    public LibrariesContainer.LibraryLevel getDefaultLevel() {
        return LibrariesContainer.LibraryLevel.PROJECT;
    }

    protected String getUrlForLibraryRoot(Class<?> clazz) {
        String _xblockexpression = null;
        String _jarPathForClass = PathUtil.getJarPathForClass(clazz);
        File libraryRoot = new File(_jarPathForClass);
        LocalFileSystem _instance = LocalFileSystem.getInstance();
        _instance.refreshAndFindFileByIoFile(libraryRoot);
        _xblockexpression = VfsUtil.getUrlForLibraryRoot((File)libraryRoot);
        return _xblockexpression;
    }

    protected static List<XtendLibraryPresentationProvider> getProviders() {
        Object[] _extensions = (LibraryPresentationProvider[])LibraryPresentationProvider.EP_NAME.getExtensions();
        return ContainerUtil.findAll((Object[])_extensions, XtendLibraryPresentationProvider.class);
    }
}

