/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.idea.config;

import com.google.common.base.Objects;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.eclipse.xtend.core.idea.config.MavenArtifact;
import org.eclipse.xtend.core.idea.config.XtendLibraryConfigurator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.idea.util.PlatformUtil;
import org.eclipse.xtext.util.XtextVersion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.jetbrains.plugins.gradle.frameworkSupport.BuildScriptDataBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleModuleBuilder;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class GradleBuildFileUtility {
    private static final Logger LOG = Logger.getInstance((String)GradleBuildFileUtility.class.getName());

    public boolean isGradleedModule(Module module) {
        PlatformUtil _platformUtil = new PlatformUtil();
        boolean _isGradleInstalled = _platformUtil.isGradleInstalled();
        if (_isGradleInstalled) {
            BuildScriptDataBuilder _buildScriptData;
            boolean _tripleNotEquals;
            boolean _or = false;
            boolean _isExternalSystemAwareModule = ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module);
            _or = _isExternalSystemAwareModule ? true : (_tripleNotEquals = (_buildScriptData = GradleModuleBuilder.getBuildScriptData((Module)module)) != null);
            return _or;
        }
        return false;
    }

    public void addXtendLibGradleDependency(Module module, final boolean isTestScope) {
        final GroovyFile buildFile = this.locateBuildFile(module);
        if (buildFile == null) {
            String _name = module.getName();
            String _plus = "Gradle build file not found in module " + _name;
            LOG.error(_plus);
            return;
        }
        Project _project = module.getProject();
        List _newImmutableList = CollectionLiterals.newImmutableList((Object[])new PsiFile[]{buildFile});
        new WriteCommandAction.Simple(_project, "Gradle: Add Xtend Runtime Library", (PsiFile[])Conversions.unwrapArray((Object)_newImmutableList, PsiFile.class)){

            protected void run() throws Throwable {
                String _xifexpression = null;
                _xifexpression = isTestScope ? "testCompile" : "compile";
                String scope = _xifexpression;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)scope, "");
                _builder.append((Object)" '");
                MavenArtifact _xtendLibMavenId = XtendLibraryConfigurator.xtendLibMavenId();
                String _key = _xtendLibMavenId.getKey();
                _builder.append((Object)_key, "");
                _builder.append((Object)"' ");
                GradleBuildFileUtility.this.addDependency((GrStatementOwner)buildFile, _builder.toString());
            }
        }.execute();
    }

    public void setupGradleBuild(Module module, GroovyFile buildFile) {
        boolean _tripleNotEquals;
        if (buildFile == null) {
            return;
        }
        final boolean android = this.isAndroidGradleModule(module);
        GrStatement[] _statements = buildFile.getStatements();
        Functions.Function1<GrStatement, Boolean> _function = new Functions.Function1<GrStatement, Boolean>(){

            public Boolean apply(GrStatement it) {
                String _text = it.getText();
                String _trim = _text.trim();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"apply plugin:.*org\\\\.xtext");
                String _xifexpression = null;
                if (android) {
                    _xifexpression = "\\.android";
                }
                _builder.append((Object)_xifexpression, "");
                _builder.append((Object)"\\\\.xtend.*");
                return _trim.matches(_builder.toString());
            }
        };
        GrStatement _findFirst = (GrStatement)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_statements)), (Functions.Function1)_function);
        boolean bl = _tripleNotEquals = _findFirst != null;
        if (_tripleNotEquals) {
            return;
        }
        GrClosableBlock buildScript = this.createOrGetMethodCall((GrStatementOwner)buildFile, "buildscript");
        GrClosableBlock _createOrGetMethodCall = this.createOrGetMethodCall((GrStatementOwner)buildScript, "repositories");
        this.createStatementIfNotExists((GrStatementOwner)_createOrGetMethodCall, "jcenter()");
        String _xifexpression = null;
        if (android) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)"classpath 'org.xtext:xtext-android-gradle-plugin:");
            XtextVersion _current = XtextVersion.getCurrent();
            String _xtendAndroidGradlePluginVersion = _current.getXtendAndroidGradlePluginVersion();
            _builder.append((Object)_xtendAndroidGradlePluginVersion, "");
            _builder.append((Object)"' ");
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append((Object)"classpath 'org.xtext:xtext-gradle-plugin:");
            XtextVersion _current_1 = XtextVersion.getCurrent();
            String _xtendGradlePluginVersion = _current_1.getXtendGradlePluginVersion();
            _builder_1.append((Object)_xtendGradlePluginVersion, "");
            _builder_1.append((Object)"' ");
            _xifexpression = _builder_1.toString();
        }
        String pluginDef = _xifexpression;
        this.addDependency((GrStatementOwner)buildScript, pluginDef);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append((Object)"apply plugin: 'org.xtext");
        String _xifexpression_1 = null;
        if (android) {
            _xifexpression_1 = ".android";
        }
        _builder_2.append((Object)_xifexpression_1, "");
        _builder_2.append((Object)".xtend' ");
        this.createStatementIfNotExists((GrStatementOwner)buildFile, _builder_2.toString());
    }

    public GroovyFile locateBuildFile(Module module) {
        String modulePath = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (modulePath != null) {
            LocalFileSystem _instance;
            VirtualFile virtualFile;
            boolean _not;
            String buildScriptPath = FileUtil.findFileInProvidedPath((String)modulePath, (String[])new String[]{"build.gradle"});
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)buildScriptPath);
            boolean bl = _not = !_isNullOrEmpty;
            if (_not && (virtualFile = (_instance = LocalFileSystem.getInstance()).refreshAndFindFileByPath(buildScriptPath)) != null) {
                boolean _isValid;
                Project _project = module.getProject();
                PsiManager _instance_1 = PsiManager.getInstance((Project)_project);
                PsiFile psiFile = _instance_1.findFile(virtualFile);
                boolean _and = false;
                _and = !(psiFile instanceof GroovyFile) ? false : (_isValid = psiFile.isValid());
                if (_and) {
                    return (GroovyFile)psiFile;
                }
            }
        }
        return null;
    }

    public void addDependency(GrStatementOwner parentElement, String dependencyEntry) {
        GrClosableBlock _createOrGetMethodCall = this.createOrGetMethodCall(parentElement, "dependencies");
        this.createStatementIfNotExists((GrStatementOwner)_createOrGetMethodCall, dependencyEntry);
    }

    private boolean createStatementIfNotExists(GrStatementOwner statementOwner, final String statement) {
        boolean _tripleNotEquals;
        GrStatement[] _statements = statementOwner.getStatements();
        Functions.Function1<GrStatement, Boolean> _function = new Functions.Function1<GrStatement, Boolean>(){

            public Boolean apply(GrStatement it) {
                String _trim = statement.trim();
                String _text = it.getText();
                return Objects.equal((Object)_trim, (Object)_text);
            }
        };
        GrStatement _findFirst = (GrStatement)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_statements)), (Functions.Function1)_function);
        boolean bl = _tripleNotEquals = _findFirst != null;
        if (_tripleNotEquals) {
            return false;
        }
        Project _project = statementOwner.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)_project);
        GrStatement entry = factory.createStatementFromText((CharSequence)statement);
        statementOwner.addStatementBefore(entry, null);
        return true;
    }

    private GrClosableBlock createOrGetMethodCall(GrStatementOwner element, final String methodName) {
        Functions.Function1<GrMethodCall, Boolean> _function;
        List methodCalls = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, GrMethodCall.class);
        GrMethodCall methodCall = (GrMethodCall)IterableExtensions.findFirst((Iterable)methodCalls, (Functions.Function1)(_function = new Functions.Function1<GrMethodCall, Boolean>(){

            public Boolean apply(GrMethodCall it) {
                boolean _xblockexpression = false;
                GrExpression expression = it.getInvokedExpression();
                boolean _and = false;
                if (expression == null) {
                    _and = false;
                } else {
                    boolean _equals;
                    String _text = expression.getText();
                    _and = _equals = methodName.equals(_text);
                }
                _xblockexpression = _and;
                return _xblockexpression;
            }
        }));
        if (methodCall == null) {
            Project _project = element.getProject();
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)_project);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append((Object)methodName, "");
            _builder.append((Object)"{}");
            GrStatement _createStatementFromText = factory.createStatementFromText((CharSequence)_builder);
            GrStatement _addStatementBefore = element.addStatementBefore(_createStatementFromText, null);
            methodCall = (GrMethodCall)_addStatementBefore;
        }
        return this.firstClosureArgument((GrCall)methodCall);
    }

    private GrClosableBlock firstClosureArgument(GrCall call) {
        GrClosableBlock[] _closureArguments = call.getClosureArguments();
        return (GrClosableBlock)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)_closureArguments)));
    }

    public boolean isAndroidGradleModule(Module module) {
        FacetManager mnr = FacetManager.getInstance((Module)module);
        Facet[] _allFacets = mnr.getAllFacets();
        Functions.Function1 _function = new Functions.Function1<Facet<?>, Boolean>(){

            public Boolean apply(Facet<?> it) {
                FacetTypeId _typeId = it.getTypeId();
                String _string = _typeId.toString();
                return Objects.equal((Object)"android-gradle", (Object)_string);
            }
        };
        Iterable foo = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_allFacets)), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)foo);
        return _size > 0;
    }
}

