/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.persistence;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;
import org.eclipse.xtext.resource.persistence.SerializableEObjectDescription;
import org.eclipse.xtext.resource.persistence.SerializableReferenceDescription;
import org.eclipse.xtext.resource.persistence.SerializationExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
public class SerializableResourceDescription
extends AbstractResourceDescription
implements Externalizable {
    private List<SerializableEObjectDescription> descriptions = CollectionLiterals.emptyList();
    private List<SerializableReferenceDescription> references = CollectionLiterals.emptyList();
    private List<QualifiedName> importedNames = CollectionLiterals.emptyList();
    private URI uRI;

    public static SerializableResourceDescription createCopy(final IResourceDescription desc) {
        SerializableResourceDescription _serializableResourceDescription = new SerializableResourceDescription();
        Procedures.Procedure1<SerializableResourceDescription> _function = new Procedures.Procedure1<SerializableResourceDescription>(){

            public void apply(SerializableResourceDescription it) {
                URI _uRI = desc.getURI();
                it.setURI(_uRI);
                Iterable<IEObjectDescription> _exportedObjects = desc.getExportedObjects();
                Functions.Function1<IEObjectDescription, SerializableEObjectDescription> _function = new Functions.Function1<IEObjectDescription, SerializableEObjectDescription>(){

                    public SerializableEObjectDescription apply(IEObjectDescription it) {
                        return SerializableResourceDescription.createCopy(it);
                    }
                };
                Iterable _map = IterableExtensions.map(_exportedObjects, (Functions.Function1)_function);
                List _list = IterableExtensions.toList((Iterable)_map);
                it.descriptions = _list;
                Iterable<IReferenceDescription> _referenceDescriptions = desc.getReferenceDescriptions();
                Functions.Function1<IReferenceDescription, SerializableReferenceDescription> _function_1 = new Functions.Function1<IReferenceDescription, SerializableReferenceDescription>(){

                    public SerializableReferenceDescription apply(IReferenceDescription it) {
                        return SerializableResourceDescription.createCopy(it);
                    }
                };
                Iterable _map_1 = IterableExtensions.map(_referenceDescriptions, (Functions.Function1)_function_1);
                List _list_1 = IterableExtensions.toList((Iterable)_map_1);
                it.references = _list_1;
                Iterable<QualifiedName> _importedNames = desc.getImportedNames();
                ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])((QualifiedName[])Conversions.unwrapArray(_importedNames, QualifiedName.class)));
                it.importedNames = _newArrayList;
            }
        };
        return (SerializableResourceDescription)ObjectExtensions.operator_doubleArrow((Object)_serializableResourceDescription, (Procedures.Procedure1)_function);
    }

    private static SerializableEObjectDescription createCopy(final IEObjectDescription desc) {
        SerializableEObjectDescription _serializableEObjectDescription = new SerializableEObjectDescription();
        Procedures.Procedure1<SerializableEObjectDescription> _function = new Procedures.Procedure1<SerializableEObjectDescription>(){

            public void apply(SerializableEObjectDescription it) {
                String[] _userDataKeys_1;
                EClass _eClass = desc.getEClass();
                it.setEClass(_eClass);
                URI _eObjectURI = desc.getEObjectURI();
                it.setEObjectURI(_eObjectURI);
                QualifiedName _qualifiedName = desc.getQualifiedName();
                it.setQualifiedName(_qualifiedName);
                String[] _userDataKeys = desc.getUserDataKeys();
                int _size = ((List)Conversions.doWrapArray((Object)_userDataKeys)).size();
                HashMap<String, String> _hashMap = new HashMap<String, String>(_size);
                it.setUserData(_hashMap);
                String[] stringArray = _userDataKeys_1 = desc.getUserDataKeys();
                int n = _userDataKeys_1.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    HashMap<String, String> _userData = it.getUserData();
                    String _userData_1 = desc.getUserData(key);
                    _userData.put(key, _userData_1);
                    ++n2;
                }
            }
        };
        return (SerializableEObjectDescription)ObjectExtensions.operator_doubleArrow((Object)_serializableEObjectDescription, (Procedures.Procedure1)_function);
    }

    private static SerializableReferenceDescription createCopy(final IReferenceDescription desc) {
        SerializableReferenceDescription _serializableReferenceDescription = new SerializableReferenceDescription();
        Procedures.Procedure1<SerializableReferenceDescription> _function = new Procedures.Procedure1<SerializableReferenceDescription>(){

            public void apply(SerializableReferenceDescription it) {
                URI _sourceEObjectUri = desc.getSourceEObjectUri();
                it.setSourceEObjectUri(_sourceEObjectUri);
                URI _targetEObjectUri = desc.getTargetEObjectUri();
                it.setTargetEObjectUri(_targetEObjectUri);
                EReference _eReference = desc.getEReference();
                it.setEReference(_eReference);
                int _indexInList = desc.getIndexInList();
                it.setIndexInList(_indexInList);
                URI _containerEObjectURI = desc.getContainerEObjectURI();
                it.setContainerEObjectURI(_containerEObjectURI);
            }
        };
        return (SerializableReferenceDescription)ObjectExtensions.operator_doubleArrow((Object)_serializableReferenceDescription, (Procedures.Procedure1)_function);
    }

    public void updateResourceURI(URI uri) {
        for (SerializableReferenceDescription ref : this.references) {
            ref.updateResourceURI(uri, this.uRI);
        }
        for (SerializableEObjectDescription desc : this.descriptions) {
            desc.updateResourceURI(uri);
        }
        this.uRI = uri;
    }

    @Override
    protected List<IEObjectDescription> computeExportedObjects() {
        return this.descriptions;
    }

    @Override
    public Iterable<QualifiedName> getImportedNames() {
        return this.importedNames;
    }

    @Override
    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        return this.references;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        URI _readURI = SerializationExtensions.readURI(in);
        this.setURI(_readURI);
        int descriptionsSize = in.readInt();
        ArrayList<SerializableEObjectDescription> _arrayList = new ArrayList<SerializableEObjectDescription>(descriptionsSize);
        this.descriptions = _arrayList;
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, descriptionsSize, true);
        Iterator iterator = _doubleDotLessThan.iterator();
        while (iterator.hasNext()) {
            Integer cfr_ignored_0 = (Integer)iterator.next();
            SerializableEObjectDescription _readCastedObject = (SerializableEObjectDescription)SerializationExtensions.readCastedObject(in);
            this.descriptions.add(_readCastedObject);
        }
        int referencesSize = in.readInt();
        ArrayList<SerializableReferenceDescription> _arrayList_1 = new ArrayList<SerializableReferenceDescription>(referencesSize);
        this.references = _arrayList_1;
        ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, referencesSize, true);
        Iterator iterator2 = _doubleDotLessThan_1.iterator();
        while (iterator2.hasNext()) {
            Integer cfr_ignored_1 = (Integer)iterator2.next();
            SerializableReferenceDescription _readCastedObject_1 = (SerializableReferenceDescription)SerializationExtensions.readCastedObject(in);
            this.references.add(_readCastedObject_1);
        }
        int importedNamesSize = in.readInt();
        ArrayList<QualifiedName> _arrayList_2 = new ArrayList<QualifiedName>(importedNamesSize);
        this.importedNames = _arrayList_2;
        ExclusiveRange _doubleDotLessThan_2 = new ExclusiveRange(0, importedNamesSize, true);
        Iterator iterator3 = _doubleDotLessThan_2.iterator();
        while (iterator3.hasNext()) {
            Integer cfr_ignored_2 = (Integer)iterator3.next();
            QualifiedName _readQualifiedName = SerializationExtensions.readQualifiedName(in);
            this.importedNames.add(_readQualifiedName);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializationExtensions.writeURI(out, this.uRI);
        int _size = this.descriptions.size();
        out.writeInt(_size);
        for (SerializableEObjectDescription desc : this.descriptions) {
            out.writeObject(desc);
        }
        int _size_1 = this.references.size();
        out.writeInt(_size_1);
        for (SerializableReferenceDescription ref : this.references) {
            out.writeObject(ref);
        }
        int _size_2 = this.importedNames.size();
        out.writeInt(_size_2);
        for (QualifiedName name : this.importedNames) {
            SerializationExtensions.writeQualifiedName(out, name);
        }
    }

    @Pure
    public List<SerializableEObjectDescription> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<SerializableEObjectDescription> descriptions) {
        this.descriptions = descriptions;
    }

    @Pure
    public List<SerializableReferenceDescription> getReferences() {
        return this.references;
    }

    public void setReferences(List<SerializableReferenceDescription> references) {
        this.references = references;
    }

    public void setImportedNames(List<QualifiedName> importedNames) {
        this.importedNames = importedNames;
    }

    @Override
    @Pure
    public URI getURI() {
        return this.uRI;
    }

    public void setURI(URI uRI) {
        this.uRI = uRI;
    }
}

