/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.idea.facet;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.intellij.facet.Facet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.LanguageInfo;
import org.eclipse.xtext.idea.facet.AbstractFacetConfiguration;
import org.eclipse.xtext.idea.facet.FacetProvider;
import org.eclipse.xtext.idea.resource.ModuleProvider;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.JavaVersion;
import org.eclipse.xtext.xbase.idea.facet.XbaseFacetConfiguration;
import org.eclipse.xtext.xbase.idea.facet.XbaseGeneratorConfigurationState;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Log
public class XbaseGeneratorConfigProvider
implements IGeneratorConfigProvider {
    @Inject
    private FacetProvider facetProvider;
    @Inject
    private LanguageInfo languageInfo;
    private static final Logger LOG = Logger.getLogger(XbaseGeneratorConfigProvider.class);

    public GeneratorConfig get(EObject context) {
        Resource _eResource = context.eResource();
        ResourceSet _resourceSet = _eResource.getResourceSet();
        final Module module = ModuleProvider.findModule(_resourceSet);
        if (module != null) {
            AbstractFacetConfiguration facetConfiguration;
            Facet<? extends AbstractFacetConfiguration> facet = this.facetProvider.getFacet(module);
            AbstractFacetConfiguration _configuration = null;
            if (facet != null) {
                _configuration = (AbstractFacetConfiguration)facet.getConfiguration();
            }
            if ((facetConfiguration = _configuration) instanceof XbaseFacetConfiguration) {
                final XbaseGeneratorConfigurationState state = ((XbaseFacetConfiguration)facetConfiguration).getState();
                GeneratorConfig _generatorConfig = new GeneratorConfig();
                Procedures.Procedure1<GeneratorConfig> _function = new Procedures.Procedure1<GeneratorConfig>(){

                    public void apply(GeneratorConfig it) {
                        String _generatedAnnotationComment = state.getGeneratedAnnotationComment();
                        it.setGeneratedAnnotationComment(_generatedAnnotationComment);
                        boolean _isGenerateGeneratedAnnotation = state.isGenerateGeneratedAnnotation();
                        it.setGenerateGeneratedAnnotation(_isGenerateGeneratedAnnotation);
                        boolean _isGenerateSuppressWarnings = state.isGenerateSuppressWarnings();
                        it.setGenerateSyntheticSuppressWarnings(_isGenerateSuppressWarnings);
                        boolean _isIncludeDateInGenerated = state.isIncludeDateInGenerated();
                        it.setIncludeDateInGeneratedAnnotation(_isIncludeDateInGenerated);
                        JavaVersion _targetJavaVersion = XbaseGeneratorConfigProvider.this.getTargetJavaVersion(state, module);
                        it.setJavaSourceVersion(_targetJavaVersion);
                    }
                };
                return (GeneratorConfig)ObjectExtensions.operator_doubleArrow((Object)_generatorConfig, (Procedures.Procedure1)_function);
            }
        }
        return new GeneratorConfig();
    }

    protected JavaVersion getTargetJavaVersion(XbaseGeneratorConfigurationState state, final Module module) {
        Object _function;
        boolean _equals_1;
        JavaVersion _xblockexpression = null;
        final String version = state.getTargetJavaVersion();
        LanguageLevel _xifexpression = null;
        boolean _or = false;
        boolean _equals = Objects.equal((Object)version, null);
        _or = _equals ? true : (_equals_1 = version.equals("Module default"));
        if (_or) {
            LanguageLevel _xblockexpression_1 = null;
            Object action = _function = new Computable<LanguageLevel>(){

                public LanguageLevel compute() {
                    return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
                }
            };
            Application _application = ApplicationManager.getApplication();
            _xifexpression = _xblockexpression_1 = (LanguageLevel)_application.runReadAction((Computable)action);
        } else {
            LanguageLevel[] _values = LanguageLevel.values();
            _function = new Functions.Function1<LanguageLevel, Boolean>(){

                public Boolean apply(LanguageLevel it) {
                    String _presentableText = it.getPresentableText();
                    return Objects.equal((Object)_presentableText, (Object)version);
                }
            };
            _xifexpression = (LanguageLevel)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)_values)), (Functions.Function1)_function);
        }
        LanguageLevel languageLevel = _xifexpression;
        JavaVersion _switchResult = null;
        if (languageLevel != null) {
            switch (languageLevel) {
                case JDK_1_3: 
                case JDK_1_4: {
                    JavaVersion _xblockexpression_2 = null;
                    String _shortName = this.languageInfo.getShortName();
                    String _plus = _shortName + " requires Java language level 1.5 or higher. Using Java 1.5.";
                    LOG.warn((Object)_plus);
                    _switchResult = _xblockexpression_2 = JavaVersion.JAVA5;
                    break;
                }
                case JDK_1_5: {
                    _switchResult = JavaVersion.JAVA5;
                    break;
                }
                case JDK_1_6: {
                    _switchResult = JavaVersion.JAVA6;
                    break;
                }
                case JDK_1_7: {
                    _switchResult = JavaVersion.JAVA7;
                    break;
                }
                default: {
                    _switchResult = JavaVersion.JAVA8;
                    break;
                }
            }
        } else {
            _switchResult = JavaVersion.JAVA8;
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }
}

