/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.psi.impl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.psi.PsiEObjectFactory;
import org.eclipse.xtext.psi.PsiEObjectIdentifier;
import org.eclipse.xtext.psi.PsiNamedEObject;
import org.eclipse.xtext.psi.impl.PsiEObjectIdentifierImpl;
import org.eclipse.xtext.psi.impl.PsiEObjectImpl;
import org.eclipse.xtext.psi.stubs.PsiNamedEObjectStub;
import org.eclipse.xtext.psi.tree.IGrammarAwareElementType;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class PsiNamedEObjectImpl<PsiE extends PsiNamedEObject, T extends PsiNamedEObjectStub<PsiE>>
extends PsiEObjectImpl<PsiE, T>
implements PsiNamedEObject {
    @Inject
    @Extension
    private PsiEObjectFactory psiEObjectFactory;
    private final IGrammarAwareElementType nameType;

    public PsiNamedEObjectImpl(T stub, IStubElementType<T, PsiE> nodeType, IGrammarAwareElementType nameType) {
        super(stub, nodeType);
        Preconditions.checkNotNull((Object)((Object)nameType));
        this.nameType = nameType;
    }

    public PsiNamedEObjectImpl(final ASTNode node, IGrammarAwareElementType ... nameTypes) {
        super(node);
        IGrammarAwareElementType _findFirst;
        boolean _isEmpty = ((List)Conversions.doWrapArray((Object)nameTypes)).isEmpty();
        boolean _not = !_isEmpty;
        Preconditions.checkArgument((boolean)_not);
        Functions.Function1<IGrammarAwareElementType, Boolean> _function = new Functions.Function1<IGrammarAwareElementType, Boolean>(){

            public Boolean apply(IGrammarAwareElementType nameType) {
                ASTNode _findChildByType = node.findChildByType((IElementType)nameType);
                return !Objects.equal((Object)_findChildByType, null);
            }
        };
        this.nameType = _findFirst = (IGrammarAwareElementType)((Object)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)nameTypes)), (Functions.Function1)_function));
    }

    @Override
    public PsiEObjectIdentifier getNameIdentifier() {
        PsiEObjectIdentifierImpl _xblockexpression = null;
        ASTNode nameNode = this.findNameNode();
        boolean _equals = Objects.equal((Object)nameNode, null);
        if (_equals) {
            return null;
        }
        PsiElement _psi = nameNode.getPsi();
        _xblockexpression = new PsiEObjectIdentifierImpl(_psi);
        return _xblockexpression;
    }

    public String getName() {
        boolean _notEquals;
        PsiNamedEObjectStub stub = (PsiNamedEObjectStub)this.getStub();
        boolean bl = _notEquals = !Objects.equal((Object)stub, null);
        if (_notEquals) {
            return stub.getName();
        }
        ITextRegion significantTextRegion = this.getSignificantTextRegion();
        int startIndex = significantTextRegion.getOffset();
        int _length = significantTextRegion.getLength();
        int endIndex = startIndex + _length;
        PsiFile _containingFile = this.getContainingFile();
        String _text = _containingFile.getText();
        String result = _text.substring(startIndex, endIndex);
        return result;
    }

    public PsiNamedEObject setName(String name) throws IncorrectOperationException {
        PsiNamedEObjectImpl _xblockexpression = null;
        ASTNode nameNode = this.findNameNode();
        boolean _equals = Objects.equal((Object)nameNode, null);
        if (_equals) {
            return this;
        }
        EObject _grammarElement = this.nameType.getGrammarElement();
        boolean _isTerminalRuleCall = GrammarUtil.isTerminalRuleCall((EObject)_grammarElement);
        if (_isTerminalRuleCall) {
            ASTNode newNameNode = this.psiEObjectFactory.createLeafIdentifier(name, nameNode);
            ASTNode _treeParent = nameNode.getTreeParent();
            _treeParent.replaceChild(nameNode, newNameNode);
        } else {
            String _name = this.getName();
            ASTNode _createCompositeIdentifier = this.psiEObjectFactory.createCompositeIdentifier(name, _name, nameNode);
            ASTNode newNameNode_1 = _createCompositeIdentifier.getFirstChildNode();
            nameNode.replaceAllChildrenToChildrenOf(newNameNode_1);
        }
        _xblockexpression = this;
        return _xblockexpression;
    }

    protected ASTNode findNameNode() {
        ASTNode _node = this.getNode();
        return _node.findChildByType((IElementType)this.nameType);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("org.eclipse.xtext.psi.impl.PsiNamedEObjectImpl");
        StringBuilder _append = builder.append("(");
        IStubElementType _elementType = this.getElementType();
        StringBuilder _append_1 = _append.append(_elementType);
        _append_1.append(")");
        return builder.toString();
    }
}

