/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.trace;

import com.google.common.base.Objects;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.psi.XtextPsiUtils;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class VirtualFileInProject {
    private final VirtualFile file;
    private final Project project;

    public static VirtualFileInProject forPsiElement(PsiElement element) {
        VirtualFile virtualFile = XtextPsiUtils.findVirtualFile(element);
        boolean _equals = Objects.equal((Object)virtualFile, null);
        if (_equals) {
            return null;
        }
        Project _project = element.getProject();
        return new VirtualFileInProject(virtualFile, _project);
    }

    public Module getModule() {
        return ModuleUtilCore.findModuleForFile((VirtualFile)this.file, (Project)this.project);
    }

    public VirtualFileInProject(VirtualFile file, Project project) {
        this.file = file;
        this.project = project;
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VirtualFileInProject other = (VirtualFileInProject)obj;
        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
            return false;
        }
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("file", (Object)this.file);
        b.add("project", (Object)this.project);
        return b.toString();
    }

    @Pure
    public VirtualFile getFile() {
        return this.file;
    }

    @Pure
    public Project getProject() {
        return this.project;
    }
}

