/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.structureview;

import com.google.common.base.Objects;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.idea.lang.IXtextLanguage;
import org.eclipse.xtext.idea.structureview.AbstractStructureViewTreeElement;
import org.eclipse.xtext.idea.structureview.AlphaSorter;
import org.eclipse.xtext.idea.structureview.DefaultComparator;
import org.eclipse.xtext.idea.structureview.IStructureViewTreeElementProvider;
import org.eclipse.xtext.idea.structureview.XtextFileTreeElement;
import org.eclipse.xtext.psi.PsiEObject;
import org.eclipse.xtext.psi.impl.BaseXtextFile;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class XtextFileTreeModel
extends TextEditorBasedStructureViewModel
implements StructureViewModel.ElementInfoProvider {
    @Accessors
    private IStructureViewTreeElementProvider structureViewTreeElementProvider;
    protected final List<Sorter> sorters;
    protected final List<Filter> filters;
    protected final List<Grouper> groupers;
    protected final List<Class<?>> suitableClasses;
    protected final List<NodeProvider> nodeProviders;

    public XtextFileTreeModel(BaseXtextFile xtextFile, Editor editor) {
        super(editor, (PsiFile)xtextFile);
        ArrayList _newArrayList_4;
        ArrayList _newArrayList_3;
        ArrayList _newArrayList_2;
        ArrayList _newArrayList_1;
        boolean _notEquals;
        ArrayList _newArrayList;
        IXtextLanguage _xtextLanguage = xtextFile.getXtextLanguage();
        _xtextLanguage.injectMembers((Object)this);
        this.sorters = _newArrayList = CollectionLiterals.newArrayList((Object[])new Sorter[0]);
        final Comparator<TreeElement> comparator = this.getComparator();
        boolean bl = _notEquals = !Objects.equal(comparator, null);
        if (_notEquals) {
            AlphaSorter _alphaSorter = new AlphaSorter();
            Procedures.Procedure1<AlphaSorter> _function = new Procedures.Procedure1<AlphaSorter>(){

                public void apply(AlphaSorter it) {
                    it.setComparator(comparator);
                }
            };
            AlphaSorter _doubleArrow = (AlphaSorter)ObjectExtensions.operator_doubleArrow((Object)_alphaSorter, (Procedures.Procedure1)_function);
            this.sorters.add(_doubleArrow);
        }
        this.filters = _newArrayList_1 = CollectionLiterals.newArrayList((Object[])new Filter[0]);
        this.groupers = _newArrayList_2 = CollectionLiterals.newArrayList((Object[])new Grouper[0]);
        this.nodeProviders = _newArrayList_3 = CollectionLiterals.newArrayList((Object[])new NodeProvider[0]);
        this.suitableClasses = _newArrayList_4 = CollectionLiterals.newArrayList((Object[])new Class[]{PsiEObject.class});
    }

    protected BaseXtextFile getPsiFile() {
        PsiFile _psiFile = super.getPsiFile();
        return (BaseXtextFile)_psiFile;
    }

    public StructureViewTreeElement getRoot() {
        XtextFileTreeElement _xblockexpression = null;
        BaseXtextFile _psiFile = this.getPsiFile();
        XtextFileTreeElement rootTreeElement = new XtextFileTreeElement(_psiFile);
        rootTreeElement.setStructureViewTreeElementProvider(this.structureViewTreeElementProvider);
        _xblockexpression = rootTreeElement;
        return _xblockexpression;
    }

    public boolean isAlwaysLeaf(StructureViewTreeElement element) {
        boolean _xifexpression = false;
        _xifexpression = element instanceof AbstractStructureViewTreeElement ? ((AbstractStructureViewTreeElement)element).isLeaf() : false;
        return _xifexpression;
    }

    public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
        return false;
    }

    public Filter[] getFilters() {
        return (Filter[])Conversions.unwrapArray(this.filters, Filter.class);
    }

    public Sorter[] getSorters() {
        return (Sorter[])Conversions.unwrapArray(this.sorters, Sorter.class);
    }

    public Grouper[] getGroupers() {
        return (Grouper[])Conversions.unwrapArray(this.groupers, Grouper.class);
    }

    public Collection<NodeProvider> getNodeProviders() {
        return this.nodeProviders;
    }

    public Comparator<TreeElement> getComparator() {
        return new DefaultComparator();
    }

    public Object getCurrentEditorElement() {
        Object _xblockexpression = null;
        Object element = super.getCurrentEditorElement();
        Object _xifexpression = null;
        if (element instanceof PsiEObject) {
            EObject _eObject = ((PsiEObject)element).getEObject();
            URI _uRI = null;
            if (_eObject != null) {
                _uRI = EcoreUtil.getURI((EObject)_eObject);
            }
            _xifexpression = _uRI;
        } else {
            _xifexpression = element;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected Object getSuperCurrentEditorElement() {
        return super.getCurrentEditorElement();
    }

    protected Class[] getSuitableClasses() {
        return (Class[])Conversions.unwrapArray(this.suitableClasses, Class.class);
    }

    @Pure
    public IStructureViewTreeElementProvider getStructureViewTreeElementProvider() {
        return this.structureViewTreeElementProvider;
    }

    public void setStructureViewTreeElementProvider(IStructureViewTreeElementProvider structureViewTreeElementProvider) {
        this.structureViewTreeElementProvider = structureViewTreeElementProvider;
    }
}

