/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.editorActions;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.idea.editorActions.TokenSetProvider;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@FinalFieldsConstructor
public class AutoEditContext {
    private final EditorEx editor;
    private final TokenSetProvider tokenSetProivder;

    public int getCaretOffset() {
        CaretModel _caretModel = this.editor.getCaretModel();
        return _caretModel.getOffset();
    }

    public DocumentEx getDocument() {
        return this.editor.getDocument();
    }

    public TokenSet getTokenSet(int offset) {
        return this.tokenSetProivder.getTokenSet(this.editor, offset);
    }

    public TokenSet getTokenSet(HighlighterIterator iterator) {
        IElementType _tokenType = iterator.getTokenType();
        return this.getTokenSet(_tokenType);
    }

    public TokenSet getTokenSet(IElementType tokenType) {
        return this.tokenSetProivder.getTokenSet(tokenType);
    }

    public HighlighterIterator createTokenIterator(int offset) {
        EditorHighlighter _highlighter = this.editor.getHighlighter();
        return _highlighter.createIterator(offset);
    }

    public boolean isSameLine(int offset, int offset2) {
        int _lineNumber_1;
        int _lineNumber = this.getLineNumber(offset);
        return _lineNumber == (_lineNumber_1 = this.getLineNumber(offset2));
    }

    public int getLineNumber(int offset) {
        DocumentEx _document = this.getDocument();
        return _document.getLineNumber(offset);
    }

    public String getText(int startOffset, int endOffset) {
        DocumentEx _document = this.getDocument();
        TextRange _textRange = new TextRange(startOffset, endOffset);
        return _document.getText(_textRange);
    }

    public boolean isStartOfLine(int offset) {
        return this.tokenSetProivder.isStartOfLine(this.editor, offset);
    }

    public boolean isEndOfLine(int offset) {
        return this.tokenSetProivder.isEndOfLine(this.editor, offset);
    }

    public int type(char c) {
        String _valueOf = String.valueOf(c);
        return EditorModificationUtil.insertStringAtCaret((Editor)this.editor, (String)_valueOf, (boolean)true, (boolean)true);
    }

    public int count(String searchMe, String toFind) {
        int length = toFind.length();
        int count = 0;
        int index = searchMe.indexOf(toFind);
        while (index > -1) {
            int _indexOf;
            ++count;
            index = _indexOf = searchMe.indexOf(toFind, index + length);
        }
        return count;
    }

    public boolean isIdentifierPart(int offset) {
        boolean _greaterThan;
        boolean _xifexpression = false;
        DocumentEx _document = this.getDocument();
        int _textLength = _document.getTextLength();
        boolean bl = _greaterThan = _textLength > offset;
        if (_greaterThan) {
            DocumentEx _document_1 = this.getDocument();
            CharSequence _charsSequence = _document_1.getCharsSequence();
            char _charAt = _charsSequence.charAt(offset);
            _xifexpression = Character.isJavaIdentifierPart(_charAt);
        }
        return _xifexpression;
    }

    public String newLine(String content) {
        return "\n" + content;
    }

    public AutoEditContext(EditorEx editor, TokenSetProvider tokenSetProivder) {
        this.editor = editor;
        this.tokenSetProivder = tokenSetProivder;
    }

    @Pure
    public EditorEx getEditor() {
        return this.editor;
    }

    @Pure
    public TokenSetProvider getTokenSetProivder() {
        return this.tokenSetProivder;
    }
}

