/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.idea.build;

import com.intellij.openapi.vfs.VirtualFile;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.idea.resource.VirtualFileURIUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class BuildEvent {
    private final Type type;
    private final Map<URI, VirtualFile> filesByURI;

    public BuildEvent(Type type, VirtualFile ... files) {
        LinkedHashMap _newLinkedHashMap;
        this.type = type;
        this.filesByURI = _newLinkedHashMap = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
        for (VirtualFile file : files) {
            URI _uRI = VirtualFileURIUtil.getURI(file);
            this.filesByURI.put(_uRI, file);
        }
    }

    public Set<URI> getURIs() {
        return this.filesByURI.keySet();
    }

    public VirtualFile getFile(URI uri) {
        return this.filesByURI.get(uri);
    }

    @Pure
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.filesByURI == null ? 0 : this.filesByURI.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildEvent other = (BuildEvent)obj;
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        return !(this.filesByURI == null ? other.filesByURI != null : !this.filesByURI.equals(other.filesByURI));
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("type", (Object)this.type);
        b.add("filesByURI", this.filesByURI);
        return b.toString();
    }

    @Pure
    public Type getType() {
        return this.type;
    }

    @Pure
    public Map<URI, VirtualFile> getFilesByURI() {
        return this.filesByURI;
    }

    public static enum Type {
        DELETED,
        MODIFIED,
        ADDED;

    }
}

