/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.type.impl.java;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.xtend.expression.TypeNameUtil;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.type.impl.java.JavaTypeImpl;
import org.eclipse.xtend.type.impl.java.JavaTypeStrategy;
import org.eclipse.xtend.type.impl.java.TypeFinder;
import org.eclipse.xtend.type.impl.java.beans.JavaBeansStrategy;
import org.eclipse.xtend.typesystem.MetaModel;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMetaModel
implements MetaModel,
TypeFinder {
    private String _name = null;
    private JavaTypeStrategy _strategy;
    private TypeSystem typeSystem;
    private final Cache<Class<?>, Type> cache = new Cache<Class<? extends Object>, Type>(){

        @Override
        protected Type createNew(Class<?> clazz) {
            JavaTypeImpl impl = new JavaTypeImpl(JavaMetaModel.this, clazz, JavaMetaModel.this.getName(clazz), JavaMetaModel.this._strategy);
            if (List.class.isAssignableFrom(clazz)) {
                return JavaMetaModel.this.typeSystem.getListType(JavaMetaModel.this.typeSystem.getObjectType());
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return JavaMetaModel.this.typeSystem.getSetType(JavaMetaModel.this.typeSystem.getObjectType());
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return JavaMetaModel.this.typeSystem.getCollectionType(JavaMetaModel.this.typeSystem.getObjectType());
            }
            return impl;
        }
    };
    private final Class<? extends JavaMetaModel> NOCLASS = this.getClass();
    private final Cache<String, Class<?>> classCache = new Cache<String, Class<? extends Object>>(){

        @Override
        protected Class<?> createNew(String typeName) {
            String classname = typeName.replaceAll("::", ".");
            try {
                Class loadedClass = ResourceLoaderFactory.createResourceLoader().loadClass(classname);
                return loadedClass == null ? JavaMetaModel.this.NOCLASS : loadedClass;
            }
            catch (Exception exception) {
                return JavaMetaModel.this.NOCLASS;
            }
        }
    };

    @Override
    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    @Override
    public void setTypeSystem(TypeSystem typeSystem) {
        if (typeSystem != null) {
            this.typeSystem = typeSystem;
        }
    }

    public JavaMetaModel() {
        this._strategy = new JavaBeansStrategy();
    }

    public JavaMetaModel(String name, JavaTypeStrategy strategy) {
        this._name = name;
        this._strategy = strategy;
    }

    private String getName(Class<?> class1) {
        return TypeNameUtil.getName(class1);
    }

    @Override
    public Type builtinAwareGetTypeForName(String typeName) {
        Type type = this.typeSystem.getTypeForName(typeName);
        if (type == null) {
            type = this.getTypeForName(typeName);
        }
        return type;
    }

    @Override
    public Type getTypeForName(String typeName) {
        Class<?> clazz = this.classCache.get(typeName);
        if (clazz == this.NOCLASS) {
            return null;
        }
        return this.getTypeForClass(clazz);
    }

    @Override
    public Type builtinAwareGetType(Object obj) {
        Type type = this.typeSystem.getType(obj);
        if (type == null) {
            type = this.getType(obj);
        }
        return type;
    }

    @Override
    public Type getType(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.getTypeForClass(obj.getClass());
    }

    @Override
    public Type builtinAwareGetTypeForClass(Class<?> clazz) {
        Type type = this.typeSystem.getTypeForName(this.getName(clazz));
        if (type == null) {
            type = this.getTypeForClass(clazz);
        }
        return type;
    }

    public Type getTypeForClass(Class<?> clazz) {
        return this.cache.get(clazz);
    }

    public Set<Type> getKnownTypes() {
        HashSet col = this.cache.getValues();
        return col instanceof Set ? col : new HashSet(col);
    }

    public String getName() {
        return this._name;
    }

    public void setTypeStrategy(JavaTypeStrategy strategy) {
        this._strategy = strategy;
    }

    @Override
    public Set<String> getNamespaces() {
        return new HashSet<String>();
    }
}

