/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.xtend.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExtension
extends SyntaxElement
implements Extension {
    private static final List<DeclaredParameter> EMPTY_DECLARED_PARAMETERS = Collections.emptyList();
    private final Identifier name;
    private final List<DeclaredParameter> formalParameters;
    protected ExtensionFile file;
    protected boolean cached = false;
    private boolean isPrivate = false;
    private final Map<List<Object>, Object> cache = new HashMap<List<Object>, Object>();
    private List<Type> parameterTypes = null;
    protected Identifier returnType;
    private String _stringRepresentation = null;
    private String _outlineRepresentation = null;

    public AbstractExtension(Identifier name, Identifier returnType, List<DeclaredParameter> formalParameters, boolean cached, boolean isPrivate) {
        this.name = name;
        this.formalParameters = formalParameters != null && !formalParameters.isEmpty() ? formalParameters : EMPTY_DECLARED_PARAMETERS;
        this.returnType = returnType;
        this.cached = cached;
        this.isPrivate = isPrivate;
    }

    @Override
    public List<DeclaredParameter> getFormalParameters() {
        return this.formalParameters;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    public Identifier getNameIdentifier() {
        return this.name;
    }

    @Override
    public final Type getReturnType(Type[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ExecutionContext _ctx = ctx.cloneWithResource(this.getExtensionFile());
        return this.internalGetReturnType(parameters, _ctx, issues);
    }

    protected abstract Type internalGetReturnType(Type[] var1, ExecutionContext var2, Set<AnalysationIssue> var3);

    @Override
    public final void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ExecutionContext _ctx = ctx;
        try {
            String returnTypeName;
            Type pt;
            if (_ctx.getCallback() != null && !_ctx.getCallback().pre(this, _ctx)) {
                return;
            }
            List<DeclaredParameter> params = this.getFormalParameters();
            HashSet<String> usedNames = new HashSet<String>();
            for (DeclaredParameter p : params) {
                String parameterName;
                String typeName = p.getType().toString();
                Type pt2 = _ctx.getTypeForName(typeName);
                if (pt2 == null) {
                    issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Type not found: " + typeName, p.getType()));
                }
                if (!usedNames.add(parameterName = p.getName().toString())) {
                    issues.add(new AnalysationIssue(AnalysationIssue.SYNTAX_ERROR, "Duplicate parameter name: " + parameterName, p.getName()));
                }
                _ctx = _ctx.cloneWithVariable(new Variable(parameterName, pt2));
            }
            if (this.returnType != null && (pt = _ctx.getTypeForName(returnTypeName = this.returnType.toString())) == null) {
                issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Type not found: " + returnTypeName, this.returnType));
            }
            try {
                this.analyzeInternal(_ctx, issues);
            }
            catch (RuntimeException ex) {
                _ctx.handleRuntimeException(ex, this, null);
            }
        }
        finally {
            if (_ctx.getCallback() != null) {
                _ctx.getCallback().post(this, _ctx, null);
            }
        }
    }

    protected void analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
    }

    @Override
    public Object evaluate(Object[] parameters, ExecutionContext ctx) {
        ExecutionContext _ctx = ctx;
        try {
            List<Object> l;
            if (_ctx.getCallback() != null && !_ctx.getCallback().pre(this, _ctx)) {
                return null;
            }
            if (this.cached && this.cache.containsKey(l = Arrays.asList(parameters))) {
                Object object = this.cache.get(l);
                return object;
            }
            if (this.getExtensionFile() == null) {
                throw new IllegalStateException("No containing file!");
            }
            _ctx = _ctx.cloneWithResource(this.getExtensionFile());
            Object result = this.evaluateInternal(parameters, _ctx);
            if (this.cached) {
                this.cache.put(Arrays.asList(parameters), result);
            }
            Object object = result;
            return object;
        }
        catch (RuntimeException ex) {
            _ctx.handleRuntimeException(ex, this, null);
        }
        finally {
            if (_ctx.getCallback() != null) {
                _ctx.getCallback().post(this, _ctx, null);
            }
        }
        return null;
    }

    @Override
    public final void setExtensionFile(ExtensionFile f) {
        this.file = f;
    }

    @Override
    public ExtensionFile getExtensionFile() {
        return this.file;
    }

    protected abstract Object evaluateInternal(Object[] var1, ExecutionContext var2);

    @Override
    public List<String> getParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (DeclaredParameter declaredParameter : this.getFormalParameters()) {
            names.add(declaredParameter.getName().toString());
        }
        return names;
    }

    @Override
    public void init(ExecutionContext ctx) {
        if (this.parameterTypes == null) {
            try {
                this.parameterTypes = new ArrayList<Type>();
                for (DeclaredParameter declaredParameter : this.getFormalParameters()) {
                    Type t = ctx.getTypeForName(declaredParameter.getType().toString());
                    if (t == null) continue;
                    this.parameterTypes.add(t);
                }
            }
            catch (RuntimeException e) {
                this.parameterTypes = null;
                throw e;
            }
        }
    }

    @Override
    public Type getReturnType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Identifier getReturnTypeIdentifier() {
        return this.returnType;
    }

    @Override
    public String toString() {
        if (this._stringRepresentation == null) {
            this._stringRepresentation = String.valueOf(this.returnType != null ? String.valueOf(this.returnType.toString()) + " " : "") + this.getName() + "(" + this.paramsToString() + ")";
        }
        return this._stringRepresentation;
    }

    @Override
    public String toOutlineString() {
        if (this._outlineRepresentation == null) {
            this._outlineRepresentation = String.valueOf(this.getName()) + "(" + this.paramsToOutlineString() + ")" + (this.returnType != null ? ": " + this.returnType.toString() : "");
        }
        return this._outlineRepresentation;
    }

    private String paramsToString() {
        StringBuffer buff = new StringBuffer();
        Iterator<DeclaredParameter> iter = this.getFormalParameters().iterator();
        while (iter.hasNext()) {
            DeclaredParameter element = iter.next();
            buff.append(element.getType() + " " + element.getName());
            if (!iter.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    private String paramsToOutlineString() {
        StringBuffer buff = new StringBuffer();
        Iterator<DeclaredParameter> iter = this.getFormalParameters().iterator();
        while (iter.hasNext()) {
            DeclaredParameter element = iter.next();
            buff.append(element.getType());
            if (!iter.hasNext()) continue;
            buff.append(", ");
        }
        return buff.toString();
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    @Override
    public boolean isCached() {
        return this.cached;
    }

    @Override
    public String getQualifiedName() {
        return String.valueOf(this.getExtensionFile().getFullyQualifiedName()) + "::" + this.getName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameterTypes == null ? 0 : this.parameterTypes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractExtension other = (AbstractExtension)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parameterTypes == null ? other.parameterTypes != null : !this.parameterTypes.equals(other.parameterTypes));
    }

    protected void checkForAmbiguousDefinitions(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Set<? extends Extension> allExtensions = ctx.getAllExtensions();
        String fileName = this.getFileName();
        for (AbstractExtension abstractExtension : allExtensions) {
            if (!this.name.equals(abstractExtension.name) || this.line == abstractExtension.line && fileName.equals(abstractExtension.getFileName()) || !this.parameterTypes.equals(abstractExtension.parameterTypes)) continue;
            issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Duplicate extension definition: " + this.toOutlineString(), this, false, this.start));
            issues.add(new AnalysationIssue(AnalysationIssue.INTERNAL_ERROR, "Duplicate extension definition: " + abstractExtension.toOutlineString(), abstractExtension, false, abstractExtension.start));
        }
    }
}

