/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.type.baseimpl.types;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.internal.xtend.type.baseimpl.OperationImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.BuiltinBaseType;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntegerTypeImpl
extends BuiltinBaseType {
    public IntegerTypeImpl(TypeSystem ts, String name) {
        super(ts, name);
    }

    @Override
    public boolean isInstance(Object o) {
        return o instanceof BigInteger || o instanceof Integer || o instanceof Byte || o instanceof Long || o instanceof Short;
    }

    @Override
    public Object newInstance() {
        return new BigInteger("-1");
    }

    @Override
    public Feature[] getContributedFeatures() {
        return new Feature[]{new OperationImpl(this, "+", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return IntegerTypeImpl.this.toInt(target).add(IntegerTypeImpl.this.toInt(params[0]));
            }
        }, new OperationImpl(this, "-", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return IntegerTypeImpl.this.toInt(target).subtract(IntegerTypeImpl.this.toInt(params[0]));
            }
        }, new OperationImpl(this, "-", (Type)this, new Type[0]){

            public Object evaluateInternal(Object target, Object[] params) {
                return IntegerTypeImpl.this.toInt(target).negate();
            }
        }, new OperationImpl(this, "*", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return IntegerTypeImpl.this.toInt(target).multiply(IntegerTypeImpl.this.toInt(params[0]));
            }
        }, new OperationImpl(this, "/", (Type)this, new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (params[0] == null) {
                    return null;
                }
                return IntegerTypeImpl.this.toInt(target).divide(IntegerTypeImpl.this.toInt(params[0]));
            }
        }, new OperationImpl(this, "==", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return new Boolean(target == params[0]);
                }
                try {
                    return IntegerTypeImpl.this.toInt(target).equals(IntegerTypeImpl.this.toInt(params[0]));
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }, new OperationImpl(this, "!=", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    if (params[0] != null) {
                        return true;
                    }
                    return false;
                }
                try {
                    return !IntegerTypeImpl.this.toInt(target).equals(IntegerTypeImpl.this.toInt(params[0]));
                }
                catch (Exception exception) {
                    return true;
                }
            }
        }, new OperationImpl(this, ">", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                try {
                    if (IntegerTypeImpl.this.toInt(target).compareTo(IntegerTypeImpl.this.toInt(params[0])) > 0) {
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
            }
        }, new OperationImpl(this, ">=", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return params[0] == null ? Boolean.TRUE : Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                try {
                    if (IntegerTypeImpl.this.toInt(target).compareTo(IntegerTypeImpl.this.toInt(params[0])) >= 0) {
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
            }
        }, new OperationImpl(this, "<", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                try {
                    if (IntegerTypeImpl.this.toInt(target).compareTo(IntegerTypeImpl.this.toInt(params[0])) < 0) {
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
            }
        }, new OperationImpl(this, "<=", this.getTypeSystem().getBooleanType(), new Type[]{this}){

            public Object evaluateInternal(Object target, Object[] params) {
                if (target == null) {
                    return params[0] == null ? Boolean.TRUE : Boolean.FALSE;
                }
                if (params[0] == null) {
                    return Boolean.FALSE;
                }
                try {
                    if (IntegerTypeImpl.this.toInt(target).compareTo(IntegerTypeImpl.this.toInt(params[0])) <= 0) {
                        return true;
                    }
                    return false;
                }
                catch (Exception exception) {
                    return Boolean.FALSE;
                }
            }
        }, new OperationImpl(this, "upTo", this.getTypeSystem().getListType(this), new Type[]{this}){

            public String getDocumentation() {
                return "returns a List of Integers starting with the value of the target expression, up to the value of the specified Integer, incremented by one.<br/>e.g. '1.upTo(5)' evaluates to {1,2,3,4,5}";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                ArrayList<BigInteger> result = new ArrayList<BigInteger>();
                BigInteger l1 = IntegerTypeImpl.this.toInt(target);
                BigInteger l2 = IntegerTypeImpl.this.toInt(params[0]);
                while (l1.compareTo(l2) <= 0) {
                    result.add(l1);
                    l1 = l1.add(BigInteger.ONE);
                }
                return result;
            }
        }, new OperationImpl(this, "upTo", this.getTypeSystem().getListType(this), new Type[]{this, this}){

            public String getDocumentation() {
                return "returns a List of Integers starting with the value of the target expression, up to the value of the first paramter, incremented by the second parameter.<br/>e.g. '1.upTo(10, 2)' evaluates to {1,3,5,7,9}";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                ArrayList<BigInteger> result = new ArrayList<BigInteger>();
                BigInteger l1 = IntegerTypeImpl.this.toInt(target);
                BigInteger l2 = IntegerTypeImpl.this.toInt(params[0]);
                BigInteger l3 = IntegerTypeImpl.this.toInt(params[1]);
                while (l1.compareTo(l2) <= 0) {
                    result.add(l1);
                    l1 = l1.add(l3);
                }
                return result;
            }
        }};
    }

    public Set<Type> getSuperTypes() {
        return Collections.singleton(this.getTypeSystem().getRealType());
    }

    protected BigInteger toInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigInteger) {
            return (BigInteger)o;
        }
        if (o instanceof Integer) {
            return BigInteger.valueOf(((Integer)o).longValue());
        }
        if (o instanceof Byte) {
            return BigInteger.valueOf(((Byte)o).longValue());
        }
        if (o instanceof Long) {
            return BigInteger.valueOf((Long)o);
        }
        if (o instanceof Short) {
            return BigInteger.valueOf(((Short)o).longValue());
        }
        throw new IllegalArgumentException(String.valueOf(o.getClass().getName()) + " not supported");
    }

    @Override
    public Object convert(Object src, Class<?> targetType) {
        BigInteger value = this.toInt(src);
        if (targetType.isAssignableFrom(BigInteger.class)) {
            return value;
        }
        if (targetType.isAssignableFrom(Long.class) || targetType.isAssignableFrom(Long.TYPE)) {
            return value.longValue();
        }
        if (targetType.isAssignableFrom(Integer.class) || targetType.isAssignableFrom(Integer.TYPE)) {
            return value.intValue();
        }
        if (targetType.isAssignableFrom(Byte.class) || targetType.isAssignableFrom(Byte.TYPE)) {
            return value.byteValue();
        }
        if (targetType.isAssignableFrom(Short.class) || targetType.isAssignableFrom(Short.TYPE)) {
            return value.shortValue();
        }
        return super.convert(src, targetType);
    }
}

