/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
public class LineAndColumn {
    private final int line;
    private final int column;

    public static LineAndColumn from(int line, int column) {
        LineAndColumn result = new LineAndColumn(line, column);
        if (line <= 0 || column <= 0) {
            String _string = result.toString();
            throw new IllegalArgumentException(_string);
        }
        return result;
    }

    private LineAndColumn(int line, int column) {
        this.line = line;
        this.column = column;
    }

    @Pure
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.line;
        result = 31 * result + this.column;
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineAndColumn other = (LineAndColumn)obj;
        if (other.line != this.line) {
            return false;
        }
        return other.column == this.column;
    }

    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("line", (Object)this.line);
        b.add("column", (Object)this.column);
        return b.toString();
    }

    @Pure
    public int getLine() {
        return this.line;
    }

    @Pure
    public int getColumn() {
        return this.column;
    }
}

