/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser.impl;

import com.google.inject.Inject;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.CompoundElement;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.XtextPackage;
import org.eclipse.xtext.nodemodel.BidiIterator;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.nodemodel.impl.NodeModelBuilder;
import org.eclipse.xtext.nodemodel.impl.SyntheticCompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.parser.ParseException;
import org.eclipse.xtext.parser.ParseResult;
import org.eclipse.xtext.parser.antlr.IPartialParsingHelper;
import org.eclipse.xtext.parser.antlr.IReferableElementsUnloader;
import org.eclipse.xtext.parser.impl.PartialParsingPointers;
import org.eclipse.xtext.parser.impl.Range;
import org.eclipse.xtext.parser.impl.TokenRegionProvider;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.XtextSwitch;

public class PartialParsingHelper
implements IPartialParsingHelper {
    private static final Logger log = Logger.getLogger(PartialParsingHelper.class);
    @Inject
    private IReferableElementsUnloader unloader;
    @Inject
    private NodeModelBuilder nodeModelBuilder = new NodeModelBuilder();
    @Inject(optional=true)
    private TokenRegionProvider tokenRegionProvider;

    @Override
    public IParseResult reparse(IParser parser, IParseResult previousParseResult, ReplaceRegion changedRegion) {
        if (parser == null) {
            throw new NullPointerException("parser may not be null");
        }
        if (previousParseResult == null) {
            throw new NullPointerException("previousParseResult and previousParseResult.rootNode may not be null");
        }
        ICompositeNode oldRootNode = previousParseResult.getRootNode();
        if (changedRegion.getEndOffset() > oldRootNode.getTotalLength()) {
            log.error((Object)("Invalid " + changedRegion + " originalLength=" + oldRootNode.getTotalLength()));
            return this.fullyReparse(parser, previousParseResult, changedRegion);
        }
        if (changedRegion.getOffset() >= oldRootNode.getTotalLength() && changedRegion.getText().trim().length() == 0) {
            return this.fullyReparse(parser, previousParseResult, changedRegion);
        }
        ReplaceRegion replaceRegion = this.tokenRegionProvider.getTokenReplaceRegion(this.insertChangeIntoReplaceRegion(oldRootNode, changedRegion), changedRegion);
        if (this.isNullEdit(oldRootNode, replaceRegion)) {
            return previousParseResult;
        }
        PartialParsingPointers parsingPointers = this.calculatePartialParsingPointers(previousParseResult, replaceRegion.getOffset(), replaceRegion.getLength());
        List<ICompositeNode> validReplaceRootNodes = parsingPointers.getValidReplaceRootNodes();
        ICompositeNode oldCompositeNode = null;
        String reparseRegion = "";
        int i = validReplaceRootNodes.size() - 1;
        while (i >= 0) {
            oldCompositeNode = validReplaceRootNodes.get(i);
            if (!(oldCompositeNode instanceof SyntheticCompositeNode) && !this.isRangePartOfExceedingLookAhead((CompositeNode)oldCompositeNode, replaceRegion)) {
                boolean replaceAtEnd = oldCompositeNode.getTotalEndOffset() == replaceRegion.getEndOffset();
                reparseRegion = this.insertChangeIntoReplaceRegion(oldCompositeNode, replaceRegion);
                if (!("".equals(reparseRegion) || replaceAtEnd && Character.isWhitespace(reparseRegion.charAt(reparseRegion.length() - 1)))) {
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("replace region: [" + oldCompositeNode.getTotalOffset() + " / length: " + oldCompositeNode.getTotalLength() + " of [" + oldRootNode.getTotalOffset() + " / lenght: " + oldRootNode.getTotalLength() + "]"));
                    break;
                }
            }
            --i;
        }
        if (oldCompositeNode == null || reparseRegion.equals("") || oldCompositeNode == oldRootNode) {
            return this.fullyReparse(parser, previousParseResult, replaceRegion);
        }
        EObject entryRuleOrRuleCall = parsingPointers.findEntryRuleOrRuleCall(oldCompositeNode);
        IParseResult newParseResult = null;
        try {
            newParseResult = entryRuleOrRuleCall instanceof RuleCall ? parser.parse((RuleCall)entryRuleOrRuleCall, new StringReader(reparseRegion), oldCompositeNode.getLookAhead()) : parser.parse((ParserRule)entryRuleOrRuleCall, new StringReader(reparseRegion));
        }
        catch (ParseException parseException) {}
        if (newParseResult == null || newParseResult.hasSyntaxErrors()) {
            return this.fullyReparse(parser, previousParseResult, replaceRegion);
        }
        if (oldRootNode.equals(oldCompositeNode)) {
            this.unloadSemanticObject(previousParseResult.getRootASTElement());
            return newParseResult;
        }
        EObject oldSemanticParentElement = oldCompositeNode.getParent().getSemanticElement();
        EObject oldSemanticElement = null;
        if (oldCompositeNode.hasDirectSemanticElement()) {
            oldSemanticElement = oldCompositeNode.getSemanticElement();
        } else {
            List<ICompositeNode> nodesEnclosingRegion = parsingPointers.getNodesEnclosingRegion();
            int i2 = nodesEnclosingRegion.size() - 1;
            while (i2 >= 0) {
                ICompositeNode enclosingNode = nodesEnclosingRegion.get(i2);
                if (enclosingNode == oldCompositeNode) break;
                if (enclosingNode.hasDirectSemanticElement()) {
                    oldSemanticElement = enclosingNode.getSemanticElement();
                }
                --i2;
            }
            if (oldSemanticElement == null) {
                return this.fullyReparse(parser, previousParseResult, replaceRegion);
            }
        }
        if (oldSemanticElement == oldSemanticParentElement) {
            throw new IllegalStateException("oldParent == oldElement");
        }
        if (oldSemanticParentElement != null) {
            EStructuralFeature feature = oldSemanticElement.eContainingFeature();
            if (feature == null) {
                return this.fullyReparse(parser, previousParseResult, replaceRegion);
            }
            oldSemanticParentElement = oldSemanticElement.eContainer();
            if (feature.isMany()) {
                List featureValueList = (List)oldSemanticParentElement.eGet(feature);
                int index = featureValueList.indexOf(oldSemanticElement);
                this.unloadSemanticObject(oldSemanticElement);
                EObject newSemanticObject = newParseResult.getRootASTElement();
                if (newSemanticObject != null) {
                    featureValueList.set(index, newParseResult.getRootASTElement());
                } else {
                    featureValueList.remove(index);
                }
            } else {
                this.unloadSemanticObject(oldSemanticElement);
                oldSemanticParentElement.eSet(feature, (Object)newParseResult.getRootASTElement());
            }
            ((ParseResult)newParseResult).setRootASTElement(previousParseResult.getRootASTElement());
        } else {
            this.unloadSemanticObject(oldSemanticElement);
        }
        if (oldCompositeNode != oldRootNode) {
            this.nodeModelBuilder.replaceAndTransferLookAhead(oldCompositeNode, newParseResult.getRootNode());
            ((ParseResult)newParseResult).setRootNode(oldRootNode);
            StringBuilder builder = new StringBuilder(oldRootNode.getText());
            replaceRegion.applyTo(builder);
            this.nodeModelBuilder.setCompleteContent(oldRootNode, builder.toString());
        }
        return newParseResult;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isRangePartOfExceedingLookAhead(CompositeNode node, ReplaceRegion replaceRegion) {
        iterator = node.basicIterator();
        lookAhead = node.getLookAhead();
        if (lookAhead != 0) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            child = (AbstractNode)iterator.next();
            if (child instanceof CompositeNode) {
                if (child.getTotalOffset() >= replaceRegion.getEndOffset()) continue;
                lookAhead = Math.max(((CompositeNode)child).getLookAhead(), lookAhead);
                continue;
            }
            if (((ILeafNode)child).isHidden() || --lookAhead != 0 || child.getTotalOffset() < replaceRegion.getEndOffset()) continue;
            return false;
lbl12:
            // 4 sources

            ** while (iterator.hasNext())
        }
lbl13:
        // 1 sources

        return lookAhead > 0;
    }

    private boolean isNullEdit(INode oldRootNode, ReplaceRegion replaceRegion) {
        if (replaceRegion.getLength() == replaceRegion.getText().length()) {
            String replacedText = oldRootNode.getText().substring(replaceRegion.getOffset(), replaceRegion.getEndOffset());
            if (replaceRegion.getText().equals(replacedText)) {
                return true;
            }
        }
        return false;
    }

    protected IParseResult fullyReparse(IParser parser, IParseResult previousParseResult, ReplaceRegion replaceRegion) {
        this.unloadSemanticObject(previousParseResult.getRootASTElement());
        String reparseRegion = this.insertChangeIntoReplaceRegion(previousParseResult.getRootNode(), replaceRegion);
        return parser.parse(new StringReader(reparseRegion));
    }

    public void unloadNode(INode node) {
        if (node != null) {
            EObject semantic = node.getSemanticElement();
            this.unloadSemanticObject(semantic);
        }
    }

    public void unloadSemanticObject(EObject object) {
        if (this.unloader != null && object != null) {
            this.unloader.unloadRoot(object);
        }
    }

    public String insertChangeIntoReplaceRegion(ICompositeNode rootNode, ReplaceRegion region) {
        StringBuilder builder = new StringBuilder(rootNode.getText());
        region.shiftBy(0 - rootNode.getTotalOffset()).applyTo(builder);
        return builder.toString();
    }

    public PartialParsingPointers calculatePartialParsingPointers(IParseResult previousParseResult, int offset, int replacedTextLength) {
        int myOffset = offset;
        int myReplacedTextLength = replacedTextLength;
        ICompositeNode oldRootNode = previousParseResult.getRootNode();
        if (myOffset == oldRootNode.getTotalLength() && myOffset != 0) {
            --myOffset;
            myReplacedTextLength = 1;
        }
        Range range = new Range(myOffset, myReplacedTextLength + myOffset);
        if (previousParseResult.hasSyntaxErrors()) {
            range.mergeAllSyntaxErrors(oldRootNode);
        }
        myOffset = range.getOffset();
        List<ICompositeNode> nodesEnclosingRegion = this.collectNodesEnclosingChangeRegion(oldRootNode, range);
        List<ICompositeNode> validReplaceRootNodes = this.internalFindValidReplaceRootNodeForChangeRegion(nodesEnclosingRegion, range);
        this.filterInvalidRootNodes(oldRootNode, validReplaceRootNodes);
        if (validReplaceRootNodes.isEmpty()) {
            validReplaceRootNodes = Collections.singletonList(oldRootNode);
        }
        return new PartialParsingPointers(oldRootNode, myOffset, myReplacedTextLength, validReplaceRootNodes, nodesEnclosingRegion);
    }

    protected void filterInvalidRootNodes(ICompositeNode oldRootNode, List<ICompositeNode> validReplaceRootNodes) {
        ListIterator<ICompositeNode> iter = validReplaceRootNodes.listIterator(validReplaceRootNodes.size());
        while (iter.hasPrevious()) {
            ICompositeNode candidate = iter.previous();
            if (this.isInvalidRootNode(oldRootNode, candidate)) {
                iter.remove();
                continue;
            }
            return;
        }
    }

    protected boolean isInvalidRootNode(ICompositeNode rootNode, ICompositeNode candidate) {
        int endOffset = candidate.getTotalEndOffset();
        if (candidate instanceof SyntheticCompositeNode) {
            return true;
        }
        if (candidate.getGrammarElement() instanceof RuleCall) {
            AbstractRule rule = ((RuleCall)candidate.getGrammarElement()).getRule();
            if (!(rule instanceof ParserRule)) {
                return true;
            }
            ParserRule casted = (ParserRule)rule;
            if (GrammarUtil.isDatatypeRule(casted) || casted.isFragment() || !casted.getParameters().isEmpty()) {
                return true;
            }
            if (this.isInvalidDueToPredicates((AbstractElement)candidate.getGrammarElement())) {
                return true;
            }
        }
        if (candidate.getGrammarElement() instanceof Action) {
            return true;
        }
        if (endOffset == rootNode.getTotalEndOffset()) {
            INode lastLeaf;
            INode lastChild = this.getLastChild(candidate);
            if (lastChild instanceof ICompositeNode && this.isInvalidLastChildNode(candidate, lastLeaf = this.getLastLeaf(candidate))) {
                return true;
            }
            if (this.isInvalidLastChildNode(candidate, lastChild)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isInvalidDueToPredicates(AbstractElement element) {
        return false;
    }

    protected boolean isInvalidLastChildNode(ICompositeNode candidate, INode lastChild) {
        if (lastChild != null && lastChild.getSyntaxErrorMessage() != null) {
            EObject lastChildGrammarElement = lastChild.getGrammarElement();
            if (lastChildGrammarElement == null) {
                return true;
            }
            AbstractElement candidateElement = this.getCandidateElement(candidate.getGrammarElement());
            if (candidateElement != null) {
                if (this.isCalledBy(lastChildGrammarElement, candidateElement)) {
                    while (candidate != null) {
                        if (candidateElement != null && this.hasMandatoryFollowElements(candidateElement)) {
                            return true;
                        }
                        if ((candidate = candidate.getParent()) == null) continue;
                        candidateElement = this.getCandidateElement(candidate.getGrammarElement());
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean isCalledBy(final EObject child, AbstractElement parent) {
        return (Boolean)new XtextSwitch<Boolean>(){
            private final Set<ParserRule> rules = new HashSet<ParserRule>(4);

            @Override
            public Boolean caseCompoundElement(CompoundElement object) {
                for (AbstractElement elem : object.getElements()) {
                    if (!((Boolean)this.doSwitch(elem)).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean caseAbstractElement(AbstractElement object) {
                if (object == child) {
                    return true;
                }
                return false;
            }

            @Override
            public Boolean caseRuleCall(RuleCall object) {
                if (object != child && !((Boolean)this.doSwitch(object.getRule())).booleanValue()) {
                    return false;
                }
                return true;
            }

            @Override
            public Boolean caseAbstractRule(AbstractRule object) {
                if (object == child) {
                    return true;
                }
                return false;
            }

            @Override
            public Boolean caseParserRule(ParserRule object) {
                if (!(object == child || this.rules.add(object) && ((Boolean)this.doSwitch(object.getAlternatives())).booleanValue())) {
                    return false;
                }
                return true;
            }
        }.doSwitch(parent);
    }

    private boolean hasMandatoryFollowElements(AbstractElement lastParsedElement) {
        if (lastParsedElement.eContainer() instanceof AbstractElement) {
            AbstractElement directParent = (AbstractElement)lastParsedElement.eContainer();
            if (directParent instanceof Group) {
                int idx;
                Group group = (Group)directParent;
                int i = idx = group.getElements().indexOf((Object)lastParsedElement) + 1;
                while (i < group.getElements().size()) {
                    if (this.isMandatory((AbstractElement)group.getElements().get(i))) {
                        return true;
                    }
                    ++i;
                }
            }
            return this.hasMandatoryFollowElements(directParent);
        }
        return false;
    }

    private boolean isMandatory(AbstractElement element) {
        return (Boolean)new XtextSwitch<Boolean>(){
            private final Set<ParserRule> rules = new HashSet<ParserRule>(4);

            @Override
            public Boolean caseAction(Action object) {
                return false;
            }

            @Override
            public Boolean caseCompoundElement(CompoundElement object) {
                if (GrammarUtil.isOptionalCardinality(object)) {
                    return false;
                }
                for (AbstractElement child : object.getElements()) {
                    if (!((Boolean)this.doSwitch(child)).booleanValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean caseAlternatives(Alternatives object) {
                if (GrammarUtil.isOptionalCardinality(object)) {
                    return false;
                }
                for (AbstractElement child : object.getElements()) {
                    if (((Boolean)this.doSwitch(child)).booleanValue()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Boolean caseAbstractElement(AbstractElement object) {
                return !GrammarUtil.isOptionalCardinality(object);
            }

            @Override
            public Boolean caseRuleCall(RuleCall object) {
                if (GrammarUtil.isOptionalCardinality(object) && !((Boolean)this.doSwitch(object.getRule())).booleanValue()) {
                    return false;
                }
                return true;
            }

            @Override
            public Boolean caseAbstractRule(AbstractRule object) {
                return true;
            }

            @Override
            public Boolean caseParserRule(ParserRule object) {
                if (this.rules.add(object) && ((Boolean)this.doSwitch(object.getAlternatives())).booleanValue()) {
                    return true;
                }
                return false;
            }
        }.doSwitch(element);
    }

    private AbstractElement getCandidateElement(EObject grammarElement) {
        if (grammarElement instanceof AbstractElement) {
            return (AbstractElement)grammarElement;
        }
        return null;
    }

    private INode getLastChild(ICompositeNode parent) {
        BidiTreeIterator<INode> iterator = parent.getAsTreeIterable().iterator();
        while (iterator.hasPrevious()) {
            INode previous = iterator.previous();
            if (previous instanceof ILeafNode) {
                return previous;
            }
            if (!(previous instanceof ICompositeNode) || ((ICompositeNode)previous).hasChildren()) continue;
            return previous;
        }
        return parent;
    }

    private INode getLastLeaf(ICompositeNode parent) {
        BidiTreeIterator<INode> iterator = parent.getAsTreeIterable().iterator();
        while (iterator.hasPrevious()) {
            INode previous = iterator.previous();
            if (!(previous instanceof ILeafNode)) continue;
            return previous;
        }
        return null;
    }

    private List<ICompositeNode> collectNodesEnclosingChangeRegion(ICompositeNode parent, Range range) {
        ArrayList<ICompositeNode> nodesEnclosingRegion = new ArrayList<ICompositeNode>();
        if (this.nodeEnclosesRegion(parent, range)) {
            this.collectNodesEnclosingChangeRegion(parent, range, nodesEnclosingRegion);
        }
        return nodesEnclosingRegion;
    }

    private void collectNodesEnclosingChangeRegion(ICompositeNode parent, Range range, List<ICompositeNode> nodesEnclosingRegion) {
        nodesEnclosingRegion.add(parent);
        BidiIterator<INode> iterator = parent.getChildren().iterator();
        while (iterator.hasPrevious()) {
            INode prev = iterator.previous();
            if (!(prev instanceof ICompositeNode) || !this.nodeEnclosesRegion((ICompositeNode)prev, range)) continue;
            this.collectNodesEnclosingChangeRegion((ICompositeNode)prev, range, nodesEnclosingRegion);
            break;
        }
    }

    protected boolean nodeEnclosesRegion(ICompositeNode node, Range range) {
        boolean result = node.getTotalOffset() <= range.getOffset() && node.getTotalEndOffset() >= range.getEndOffset();
        return result;
    }

    private List<ICompositeNode> internalFindValidReplaceRootNodeForChangeRegion(List<ICompositeNode> nodesEnclosingRegion, Range range) {
        ArrayList<ICompositeNode> result = new ArrayList<ICompositeNode>();
        boolean mustSkipNext = false;
        ICompositeNode previous = null;
        boolean done = false;
        int i = 0;
        while (i < nodesEnclosingRegion.size() && !done) {
            ICompositeNode node = nodesEnclosingRegion.get(i);
            if (node.getGrammarElement() != null) {
                if (!mustSkipNext) {
                    ICompositeNode actualNode;
                    EObject semanticElement;
                    boolean process = true;
                    if (previous != null && !node.hasNextSibling() && previous.getLookAhead() == node.getLookAhead() && previous.getLookAhead() == 0) {
                        process = false;
                    }
                    if ((semanticElement = NodeModelUtils.findActualSemanticObjectFor(node)) != null && (actualNode = NodeModelUtils.findActualNodeFor(semanticElement)) != null && (actualNode.getTotalOffset() < node.getTotalOffset() || actualNode.getTotalEndOffset() > node.getTotalEndOffset())) {
                        process = false;
                    }
                    if (process) {
                        int remainingLookAhead = node.getLookAhead();
                        if (remainingLookAhead != 0) {
                            Iterator<ILeafNode> iterator = node.getLeafNodes().iterator();
                            while (iterator.hasNext() && remainingLookAhead > 0) {
                                ILeafNode leaf = iterator.next();
                                if (leaf.isHidden()) continue;
                                if (remainingLookAhead > 0) {
                                    --remainingLookAhead;
                                }
                                if (remainingLookAhead != 0) continue;
                                if (leaf.getTotalEndOffset() <= range.getOffset()) {
                                    result.add(node);
                                    previous = node;
                                    if (!this.isActionNode(node)) break;
                                    mustSkipNext = true;
                                    break;
                                }
                                done = true;
                            }
                            if (remainingLookAhead != 0) {
                                done = true;
                            }
                        } else {
                            result.add(node);
                            previous = node;
                            if (this.isActionNode(node)) {
                                mustSkipNext = true;
                            }
                        }
                    }
                } else {
                    mustSkipNext = this.isActionNode(node);
                }
            }
            ++i;
        }
        return result;
    }

    protected boolean isActionNode(ICompositeNode node) {
        return node.getGrammarElement() != null && node.getGrammarElement().eClass() == XtextPackage.Literals.ACTION;
    }

    public void setUnloader(IReferableElementsUnloader unloader) {
        this.unloader = unloader;
    }

    public IReferableElementsUnloader getUnloader() {
        return this.unloader;
    }

    public void setTokenRegionProvider(TokenRegionProvider tokenRegionProvider) {
        this.tokenRegionProvider = tokenRegionProvider;
    }
}

