/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.compiler.batch;

import com.google.common.base.Joiner;
import com.google.inject.Injector;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.apache.log4j.BasicConfigurator;
import org.eclipse.xtend.core.XtendInjectorSingleton;
import org.eclipse.xtend.core.compiler.batch.XtendBatchCompiler;
import org.eclipse.xtend.core.macro.AnnotationProcessor;
import org.eclipse.xtext.util.JavaVersion;

public class Main {
    public static void main(String[] args) {
        BasicConfigurator.configure();
        Injector injector = XtendInjectorSingleton.INJECTOR;
        XtendBatchCompiler compiler = (XtendBatchCompiler)injector.getInstance(XtendBatchCompiler.class);
        if (args == null || args.length == 0) {
            Main.printUsage();
            return;
        }
        Iterator<String> arguments = Arrays.asList(args).iterator();
        while (arguments.hasNext()) {
            String argument = arguments.next().trim();
            if ("-d".equals(argument)) {
                compiler.setOutputPath(arguments.next().trim());
                continue;
            }
            if ("-classpath".equals(argument) || "-cp".equals(argument)) {
                compiler.setClassPath(arguments.next().trim());
                continue;
            }
            if ("-tempdir".equals(argument) || "-td".equals(argument)) {
                compiler.setTempDirectory(arguments.next().trim());
                continue;
            }
            if ("-encoding".equals(argument)) {
                compiler.setFileEncoding(arguments.next().trim());
                continue;
            }
            if ("-javaSourceVersion".equals(argument)) {
                compiler.setJavaSourceVersion(arguments.next().trim());
                continue;
            }
            if ("-noSuppressWarningsAnnotation".equals(argument)) {
                compiler.setGenerateSyntheticSuppressWarnings(false);
                continue;
            }
            if ("-noUseXbaseGenerated".equals(argument)) {
                compiler.setUseXbaseGenerated(false);
                continue;
            }
            if ("-generateGeneratedAnnotation".equals(argument)) {
                compiler.setGenerateGeneratedAnnotation(true);
                continue;
            }
            if ("-includeDateInGeneratedAnnnotation".equals(argument)) {
                compiler.setIncludeDateInGeneratedAnnotation(true);
                continue;
            }
            if ("-generateAnnotationComment".equals(argument)) {
                compiler.setGeneratedAnnotationComment(arguments.next().trim());
                continue;
            }
            if ("-useCurrentClassLoader".equals(argument)) {
                compiler.setUseCurrentClassLoaderAsParent(true);
                continue;
            }
            if ("-writeTraceFiles".equals(argument)) {
                compiler.setWriteTraceFiles(true);
                continue;
            }
            if ("-verbose".equals(argument)) {
                compiler.setVerbose(true);
                continue;
            }
            ArrayList<String> existingDirs = new ArrayList<String>(compiler.getSourcePathDirectories());
            existingDirs.add(argument);
            String pathes = Joiner.on((String)File.pathSeparator).join(existingDirs);
            compiler.setSourcePath(pathes);
        }
        if (!compiler.compile()) {
            System.exit(1);
        }
        ((AnnotationProcessor.CancellationObserver)injector.getInstance(AnnotationProcessor.CancellationObserver.class)).stop();
    }

    private static void printUsage() {
        PrintStream out = System.out;
        String allVersionQualifiers = Arrays.stream(JavaVersion.values()).map(v -> v.getQualifier()).collect(Collectors.joining(", "));
        out.println("Usage: Main <options> <source directories>");
        out.println("where possible options include:");
        out.println("-d <directory>                      Specify where to place generated xtend files");
        out.println("-tp <path>                          Temp directory to hold generated stubs and classes");
        out.println("-cp <path>                          Specify where to find user class files");
        out.println("-encoding <encoding>                Specify character encoding used by source files");
        out.println("-javaSourceVersion <version>        Create Java Source compatible to this version. Can be: " + allVersionQualifiers);
        out.println("-noSuppressWarningsAnnotation       Don't put @SuppressWarnings() into generated Java Code");
        out.println("-noUseXbaseGenerated                Don't put @XbaseGenerated() into generated Java Code");
        out.println("-generateGeneratedAnnotation        Put @Generated into generated Java Code");
        out.println("-includeDateInGeneratedAnnnotation  If -generateGeneratedAnnotation is used, add the current date/time.");
        out.println("-generateAnnotationComment <string> If -generateGeneratedAnnotation is used, add a comment.");
        out.println("-useCurrentClassLoader              Use current classloader as parent classloader");
        out.println("-writeTraceFiles                    Write Trace-Files");
        out.println("-verbose                            Run compiler in verbose mode");
    }
}

