/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.services.base.TreeModelBuilderBase;
import org.eclipse.qvt.declarative.editor.AbstractOutlineElement;
import org.eclipse.qvt.declarative.editor.EditorPackage;
import org.eclipse.qvt.declarative.editor.OutlineBehavior;
import org.eclipse.qvt.declarative.editor.OutlineElement;
import org.eclipse.qvt.declarative.editor.OutlineGroup;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonEditorDefinition;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonPlugin;
import org.eclipse.qvt.declarative.parser.utils.ASTandCST;
import org.eclipse.qvt.declarative.parser.utils.CommonASTVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonTreeModelBuilder
extends TreeModelBuilderBase {
    protected final ICreationFactory creationFactory;
    protected final boolean showAST;
    protected final Map<Object, ModelTreeNode> itemMap = new HashMap<Object, ModelTreeNode>();

    public CommonTreeModelBuilder(ICreationFactory creationFactory, boolean showAST) {
        this.creationFactory = creationFactory;
        this.showAST = showAST;
    }

    protected CommonASTModelVisitor<Notifier> createASTVisitor(CommonEditorDefinition editorDefinition) {
        return new CommonASTModelVisitor<Notifier>(editorDefinition, Notifier.class);
    }

    protected ModelTreeNode createSubItem(Object n, int category) {
        ModelTreeNode item = super.createSubItem(n, category);
        this.itemMap.put(n, item);
        return item;
    }

    protected ModelTreeNode createTopItem(Object n, int category) {
        ModelTreeNode item = super.createTopItem(n, category);
        this.itemMap.clear();
        this.itemMap.put(n, item);
        return item;
    }

    public ICreationFactory getCreationFactory() {
        return this.creationFactory;
    }

    public ModelTreeNode getItem(Object n) {
        return this.itemMap.get(n);
    }

    public ICommonPlugin getPlugin() {
        return this.creationFactory.getPlugin();
    }

    public void visitTree(Object root) {
        if (root instanceof ASTandCST) {
            root = this.showAST ? ((ASTandCST)root).getAST() : ((ASTandCST)root).getCST();
        }
        CommonEditorDefinition editorDefinition = this.getPlugin().getEditorDefinition();
        this.createASTVisitor(editorDefinition).enter(root);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CommonASTModelVisitor<N>
    extends CommonASTVisitor<Object, N> {
        protected final CommonEditorDefinition editorDefinition;

        public CommonASTModelVisitor(CommonEditorDefinition editorDefinition, Class<N> nodeClass) {
            super(nodeClass);
            this.editorDefinition = editorDefinition;
        }

        protected void enterElement(N astNode, AbstractOutlineElement element) {
            if (element instanceof OutlineElement) {
                this.enterOutlineElement(astNode, (OutlineElement)element);
            } else if (element instanceof OutlineGroup) {
                this.enterOutlineGroup(astNode, (OutlineGroup)element);
            } else {
                this.unexpectedEnterOutline(astNode, element);
            }
        }

        protected void enterOutlineElement(N astNode, OutlineElement element) {
            if (astNode instanceof EObject) {
                this.enter(((EObject)astNode).eGet(element.getFeature(), false));
            } else {
                this.unexpectedEnterOutline(astNode, (AbstractOutlineElement)element);
            }
        }

        protected void enterOutlineGroup(N astNode, OutlineGroup group) {
            for (AbstractOutlineElement element : group.getElements()) {
                this.enterElement(astNode, element);
            }
        }

        public Object postVisit(N astNode) {
            OutlineBehavior behavior = this.editorDefinition.getBehavior(astNode, OutlineBehavior.class);
            if (behavior != null) {
                CommonTreeModelBuilder.this.popSubItem();
            }
            return super.postVisit(astNode);
        }

        public boolean preVisit(N astNode) {
            OutlineBehavior behavior = this.editorDefinition.getBehavior(astNode, OutlineBehavior.class);
            if (behavior != null) {
                boolean terminal;
                boolean bl = terminal = behavior.eIsSet((EStructuralFeature)EditorPackage.Literals.OUTLINE_BEHAVIOR__ELEMENTS) && behavior.getElements().isEmpty();
                if (!terminal) {
                    CommonTreeModelBuilder.this.pushSubItem(astNode);
                } else {
                    CommonTreeModelBuilder.this.createSubItem(astNode);
                }
                if (terminal) {
                    return false;
                }
            }
            return true;
        }

        protected void unexpectedEnterOutline(N astNode, AbstractOutlineElement element) {
            QVTEditorPlugin.logError("Unexpected enter outline for a '" + element.getClass().getName() + "' at a '" + astNode.getClass().getSimpleName() + "' by a '" + ((Object)((Object)this)).getClass().getSimpleName() + "'", null);
        }

        public void visitEObject(N astNode) {
            OutlineBehavior behavior = this.editorDefinition.getBehavior(astNode, OutlineBehavior.class);
            if (behavior != null && behavior.eIsSet((EStructuralFeature)EditorPackage.Literals.OUTLINE_BEHAVIOR__ELEMENTS)) {
                for (AbstractOutlineElement element : behavior.getElements()) {
                    this.enterElement(astNode, element);
                }
                return;
            }
            super.visitEObject(astNode);
        }
    }
}

