/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.runtime;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class PluginImages {
    private static ImageRegistry fgImageRegistry = null;
    private static Map<String, ImageDescriptor> fgAvoidSWTErrorMap = null;
    public static final IPath ICONS_PATH = new Path("/icons");
    private static final String NAME_PREFIX = "";
    private static final int NAME_PREFIX_LENGTH = "".length();
    public static final String VIEW_MENU_IMAGE = "view_menu.gif";
    public static final ImageDescriptor viewMenuImageDesc = PluginImages.createManaged("", "view_menu.gif");
    public static final String FILE_IMAGE = "file.gif";
    public static final ImageDescriptor fileImageDesc = PluginImages.createManaged("", "file.gif");
    public static final String FOLDER_IMAGE = "folder.gif";
    public static final ImageDescriptor folderImageDesc = PluginImages.createManaged("", "folder.gif");
    public static final String PROJECT_IMAGE = "project.gif";
    public static final ImageDescriptor projectImageDesc = PluginImages.createManaged("", "project.gif");

    public static Image get(String key) {
        return PluginImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getDescriptor(String key) {
        if (fgImageRegistry == null) {
            return fgAvoidSWTErrorMap.get(key);
        }
        return PluginImages.getImageRegistry().getDescriptor(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        PluginImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        PluginImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            for (String key : fgAvoidSWTErrorMap.keySet()) {
                fgImageRegistry.put(key, fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = PluginImages.create("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = PluginImages.create("e" + type, relPath);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        ImageDescriptor result = PluginImages.create(prefix, name.substring(NAME_PREFIX_LENGTH), true);
        if (fgAvoidSWTErrorMap == null) {
            fgAvoidSWTErrorMap = new HashMap<String, ImageDescriptor>();
        }
        fgAvoidSWTErrorMap.put(name, result);
        if (fgImageRegistry != null) {
            RuntimePlugin.getInstance().writeErrorMsg("Image registry already defined");
        }
        return result;
    }

    private static ImageDescriptor createManaged(String prefix, String name, String key) {
        ImageDescriptor result = PluginImages.create(prefix, name.substring(NAME_PREFIX_LENGTH), true);
        if (fgAvoidSWTErrorMap == null) {
            fgAvoidSWTErrorMap = new HashMap<String, ImageDescriptor>();
        }
        fgAvoidSWTErrorMap.put(key, result);
        if (fgImageRegistry != null) {
            RuntimePlugin.getInstance().writeErrorMsg("Image registry already defined");
        }
        return result;
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return PluginImages.createImageDescriptor(RuntimePlugin.getInstance().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor create(String prefix, String name) {
        return PluginImages.create(prefix, name, true);
    }

    public static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }
}

