/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.profile.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConstrainedToolbarLayoutEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.diagram.common.async.AsyncDiagramComponentEditPolicy;
import org.eclipse.uml2.diagram.common.draw2d.CenterLayout;
import org.eclipse.uml2.diagram.common.editparts.PrimaryShapeEditPart;
import org.eclipse.uml2.diagram.common.editpolicies.U2TResizableShapeEditPolicy;
import org.eclipse.uml2.diagram.profile.edit.parts.ReferencedMetaclassNode_classNameEditPart;
import org.eclipse.uml2.diagram.profile.edit.policies.ElementImportItemSemanticEditPolicy;
import org.eclipse.uml2.diagram.profile.edit.policies.UMLTextSelectionEditPolicy;
import org.eclipse.uml2.diagram.profile.part.UMLVisualIDRegistry;
import org.eclipse.uml2.diagram.profile.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.PackageableElement;

public class ElementImportEditPart
extends ShapeNodeEditPart
implements PrimaryShapeEditPart {
    public static final int VISUAL_ID = 2006;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public ElementImportEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ElementImportItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new AsyncDiagramComponentEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        ConstrainedToolbarLayoutEditPolicy lep = new ConstrainedToolbarLayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child.getEditPolicy((Object)"PrimaryDrag Policy") == null && child instanceof ITextAwareEditPart) {
                    return new UMLTextSelectionEditPolicy();
                }
                return super.createChildEditPolicy(child);
            }
        };
        return lep;
    }

    protected IFigure createNodeShapeGen() {
        ReferencedMetaclassFigure figure = new ReferencedMetaclassFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    protected IFigure createNodeShape() {
        ReferencedMetaclassFigure result = (ReferencedMetaclassFigure)this.createNodeShapeGen();
        this.refreshHasImportedMetaclass(result);
        return result;
    }

    public ReferencedMetaclassFigure getPrimaryShape() {
        return (ReferencedMetaclassFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ReferencedMetaclassNode_classNameEditPart) {
            ((ReferencedMetaclassNode_classNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureReferencedMetaclassFigure_className());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(40, 40);
        return result;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        U2TResizableShapeEditPolicy result = new U2TResizableShapeEditPolicy();
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setBackgroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setBackgroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5008));
    }

    public List getMARelTypesOnTarget() {
        ArrayList<IHintedType> types = new ArrayList<IHintedType>();
        types.add(UMLElementTypes.Extension_4002);
        types.add(UMLElementTypes.ConstraintConstrainedElement_4003);
        types.add(UMLElementTypes.CommentAnnotatedElement_4004);
        return types;
    }

    public List getMATypesForSource(IElementType relationshipType) {
        ArrayList<IHintedType> types = new ArrayList<IHintedType>();
        if (relationshipType == UMLElementTypes.Extension_4002) {
            types.add(UMLElementTypes.Stereotype_2001);
        }
        if (relationshipType == UMLElementTypes.ConstraintConstrainedElement_4003) {
            types.add(UMLElementTypes.Constraint_2008);
        }
        if (relationshipType == UMLElementTypes.CommentAnnotatedElement_4004) {
            types.add(UMLElementTypes.Comment_2009);
        }
        return types;
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        if (notification.getNotifier() instanceof ElementImport) {
            this.refreshHasImportedMetaclass(this.getPrimaryShape());
        }
    }

    private void refreshHasImportedMetaclass(ReferencedMetaclassFigure figure) {
        ElementImport elementImport = (ElementImport)this.resolveSemanticElement();
        boolean hasMetaclass = false;
        if (elementImport != null) {
            PackageableElement imported = elementImport.getImportedElement();
            hasMetaclass = imported instanceof Class && ((Class)imported).isMetaclass();
        }
        figure.setHasActualMetaclassImport(hasMetaclass);
    }

    public class ReferencedMetaclassFigure
    extends RectangleFigure {
        private Label fFigureReferencedMetaclassFigure_className;
        private boolean myUseLocalCoordinates = false;

        public ReferencedMetaclassFigure() {
            ToolbarLayout layoutThis = new ToolbarLayout();
            layoutThis.setStretchMinorAxis(true);
            layoutThis.setMinorAlignment(0);
            layoutThis.setSpacing(0);
            layoutThis.setVertical(true);
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setLineWidth(1);
            this.setForegroundColor(ColorConstants.gray);
            this.setBorder((Border)new MarginBorder(ElementImportEditPart.this.getMapMode().DPtoLP(1), ElementImportEditPart.this.getMapMode().DPtoLP(1), ElementImportEditPart.this.getMapMode().DPtoLP(1), ElementImportEditPart.this.getMapMode().DPtoLP(1)));
            this.createContents();
        }

        private void createContents() {
            RectangleFigure referencedMetaclassFigure_FixedLabelPane0 = new RectangleFigure();
            referencedMetaclassFigure_FixedLabelPane0.setFill(false);
            referencedMetaclassFigure_FixedLabelPane0.setOutline(false);
            referencedMetaclassFigure_FixedLabelPane0.setLineWidth(1);
            referencedMetaclassFigure_FixedLabelPane0.setBorder((Border)new MarginBorder(ElementImportEditPart.this.getMapMode().DPtoLP(5), ElementImportEditPart.this.getMapMode().DPtoLP(5), ElementImportEditPart.this.getMapMode().DPtoLP(0), ElementImportEditPart.this.getMapMode().DPtoLP(5)));
            this.add((IFigure)referencedMetaclassFigure_FixedLabelPane0);
            CenterLayout layoutReferencedMetaclassFigure_FixedLabelPane0 = new CenterLayout();
            referencedMetaclassFigure_FixedLabelPane0.setLayoutManager((LayoutManager)layoutReferencedMetaclassFigure_FixedLabelPane0);
            Label referencedMetaclassFigure_fixed_metaclass1 = new Label();
            referencedMetaclassFigure_fixed_metaclass1.setText("\u00abmetaclass\u00bb");
            referencedMetaclassFigure_FixedLabelPane0.add((IFigure)referencedMetaclassFigure_fixed_metaclass1);
            RectangleFigure referencedMetaclassFigure_LabelPane0 = new RectangleFigure();
            referencedMetaclassFigure_LabelPane0.setFill(false);
            referencedMetaclassFigure_LabelPane0.setOutline(false);
            referencedMetaclassFigure_LabelPane0.setLineWidth(1);
            this.add((IFigure)referencedMetaclassFigure_LabelPane0);
            CenterLayout layoutReferencedMetaclassFigure_LabelPane0 = new CenterLayout();
            referencedMetaclassFigure_LabelPane0.setLayoutManager((LayoutManager)layoutReferencedMetaclassFigure_LabelPane0);
            this.fFigureReferencedMetaclassFigure_className = new Label();
            this.fFigureReferencedMetaclassFigure_className.setText("");
            referencedMetaclassFigure_LabelPane0.add((IFigure)this.fFigureReferencedMetaclassFigure_className);
        }

        public Label getFigureReferencedMetaclassFigure_className() {
            return this.fFigureReferencedMetaclassFigure_className;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public void setHasActualMetaclassImport(boolean hasActualMetaclassImport) {
            this.setForegroundColor(hasActualMetaclassImport ? ColorConstants.gray : ColorConstants.red);
        }
    }
}

