/**
 * Copyright (c) 2006, 2014 Borland Software Corporation, Christian W. Damus, and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Dmitry Stadnik (Borland) - initial API and implementation
 *    Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Christian W. Damus - bug 451230
 *    Benoit Maggi (CEA LIST) -#510281 change dependency to replace gmft-runtime
 */
package aspects.xpt.providers;

import aspects.xpt.CodeStyle;
import aspects.xpt.Common;
import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import plugin.Activator;
import xpt.diagram.Utils_qvto;
import xpt.editor.VisualIDRegistry;

@Singleton
@SuppressWarnings("all")
public class ElementTypes extends xpt.providers.ElementTypes {
  @Inject
  @Extension
  private Common _common;
  
  @Inject
  @Extension
  private Utils_qvto _utils_qvto;
  
  @Inject
  private CodeStyle xptCodeStyle;
  
  @Inject
  private VisualIDRegistry xptVisualIDRegistry;
  
  @Inject
  private Activator xptActivator;
  
  @Override
  public CharSequence attributes(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static java.util.Map<org.eclipse.gmf.runtime.emf.type.core.IElementType, org.eclipse.emf.ecore.ENamedElement> elements;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("private static org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.providers.DiagramElementTypeImages elementTypeImages = new org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.providers.DiagramElementTypeImages(");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName);
    _builder.append(".getInstance().getItemProvidersAdapterFactory());");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2);
    _builder.newLineIfNotEmpty();
    _builder.append("private static java.util.Set<org.eclipse.gmf.runtime.emf.type.core.IElementType> KNOWN_ELEMENT_TYPES;");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getElement(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment("Returns \'type\' of the ecore object associated with the hint.\n");
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static synchronized org.eclipse.emf.ecore.ENamedElement getElement(org.eclipse.core.runtime.IAdaptable hint) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("Object type = hint.getAdapter(org.eclipse.gmf.runtime.emf.type.core.IElementType.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (elements == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("elements = new java.util.IdentityHashMap<org.eclipse.gmf.runtime.emf.type.core.IElementType, org.eclipse.emf.ecore.ENamedElement>();");
    _builder.newLine();
    _builder.append("\t\t");
    {
      GenClass _domainDiagramElement = it.getDomainDiagramElement();
      boolean _notEquals = (!Objects.equal(_domainDiagramElement, null));
      if (_notEquals) {
        CharSequence _bindUniqueIdentifierToNamedElement = this.bindUniqueIdentifierToNamedElement(it.getDomainDiagramElement(), this._common.stringUniqueIdentifier(it));
        _builder.append(_bindUniqueIdentifierToNamedElement, "\t\t");
      }
    }
    _builder.newLineIfNotEmpty();
    {
      EList<GenNode> _allNodes = it.getAllNodes();
      for(final GenNode node : _allNodes) {
        _builder.append("\t\t");
        {
          TypeModelFacet _modelFacet = node.getModelFacet();
          boolean _notEquals_1 = (!Objects.equal(_modelFacet, null));
          if (_notEquals_1) {
            CharSequence _bindUniqueIdentifierToNamedElement_1 = this.bindUniqueIdentifierToNamedElement(node.getModelFacet(), this._common.stringUniqueIdentifier(node));
            _builder.append(_bindUniqueIdentifierToNamedElement_1, "\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<GenLink> _links = it.getLinks();
      for(final GenLink link : _links) {
        _builder.append("\t\t");
        {
          LinkModelFacet _modelFacet_1 = link.getModelFacet();
          boolean _notEquals_2 = (!Objects.equal(_modelFacet_1, null));
          if (_notEquals_2) {
            CharSequence _bindUniqueIdentifierToNamedElement_2 = this.bindUniqueIdentifierToNamedElement(link.getModelFacet(), this._common.stringUniqueIdentifier(link));
            _builder.append(_bindUniqueIdentifierToNamedElement_2, "\t\t");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return elements.get(type);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence isKnownElementType(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static synchronized boolean isKnownElementType(org.eclipse.gmf.runtime.emf.type.core.IElementType elementType) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (KNOWN_ELEMENT_TYPES == null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("KNOWN_ELEMENT_TYPES = new java.util.HashSet<org.eclipse.gmf.runtime.emf.type.core.IElementType>();");
    _builder.newLine();
    {
      List<GenCommonBase> _allTypedElements = this._utils_qvto.getAllTypedElements(it);
      for(final GenCommonBase e : _allTypedElements) {
        _builder.append("\t\t");
        CharSequence _addKnownElementType = this.addKnownElementType(e);
        _builder.append(_addKnownElementType, "\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("boolean result = KNOWN_ELEMENT_TYPES.contains(elementType);");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("if (!result) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType[] supertypes = elementType.getAllSuperTypes();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("for (int i = 0; !result && (i < supertypes.length); i++) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("result = KNOWN_ELEMENT_TYPES.contains(supertypes[i]);");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence additions(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _additions = super.additions(it);
    _builder.append(_additions);
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static boolean isKindOf(org.eclipse.gmf.runtime.emf.type.core.IElementType subtype, org.eclipse.gmf.runtime.emf.type.core.IElementType supertype) {");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("boolean result = subtype == supertype;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("if (!result) {");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType[] supertypes = subtype.getAllSuperTypes();");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("for (int i = 0; !result && (i < supertypes.length); i++) {");
    _builder.newLine();
    _builder.append("            ");
    _builder.append("result = supertype == supertypes[i];");
    _builder.newLine();
    _builder.append("        ");
    _builder.append("}");
    _builder.newLine();
    _builder.append("    ");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("    ");
    _builder.append("return result;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getElementTypeByVisualID(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static org.eclipse.gmf.runtime.emf.type.core.IElementType getElementType(String visualID) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (visualID != null) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("switch (visualID) {");
    _builder.newLine();
    {
      final Function1<GenCommonBase, Boolean> _function = new Function1<GenCommonBase, Boolean>() {
        @Override
        public Boolean apply(final GenCommonBase el) {
          ElementType _elementType = el.getElementType();
          return Boolean.valueOf((!Objects.equal(_elementType, null)));
        }
      };
      Iterable<GenCommonBase> _filter = IterableExtensions.<GenCommonBase>filter(this._utils_qvto.getAllTypedElements(it), _function);
      for(final GenCommonBase e : _filter) {
        _builder.append("\t\t\t");
        CharSequence _caseElementType = this.caseElementType(e);
        _builder.append(_caseElementType, "\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence getElementType(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("private static org.eclipse.gmf.runtime.emf.type.core.IElementType getElementTypeByUniqueId(String id) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry.getInstance().getType(id);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence elementTypeField(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      ElementType _elementType = it.getElementType();
      boolean _notEquals = (!Objects.equal(null, _elementType));
      if (_notEquals) {
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append(_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public static final org.eclipse.gmf.runtime.emf.type.core.IElementType ");
        String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
        _builder.append(_stringUniqueIdentifier);
        _builder.append(" = getElementTypeByUniqueId(\"");
        String _uniqueIdentifier = it.getElementType().getUniqueIdentifier();
        _builder.append(_uniqueIdentifier);
        _builder.append("\"); ");
        CharSequence _nonNLS = this._common.nonNLS(1);
        _builder.append(_nonNLS);
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  @Override
  public CharSequence typedInstance(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static final org.eclipse.papyrus.infra.gmfdiag.common.providers.DiagramElementTypes TYPED_INSTANCE ");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("= new org.eclipse.papyrus.infra.gmfdiag.common.providers.DiagramElementTypes(elementTypeImages) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public boolean isKnownElementType(org.eclipse.gmf.runtime.emf.type.core.IElementType elementType) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".isKnownElementType(elementType);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_1 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_1, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.gmf.runtime.emf.type.core.IElementType getElementTypeForVisualId(String visualID) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName_1 = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_1, "\t\t");
    _builder.append(".getElementType(visualID);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment_2 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _overrideC_2 = this.xptCodeStyle.overrideC(it);
    _builder.append(_overrideC_2, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public org.eclipse.emf.ecore.ENamedElement getDefiningNamedElement(org.eclipse.core.runtime.IAdaptable elementTypeAdapter) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ");
    CharSequence _qualifiedClassName_2 = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName_2, "\t\t");
    _builder.append(".getElement(elementTypeAdapter);");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}; ");
    _builder.newLine();
    return _builder;
  }
  
  @Override
  public CharSequence accessElementType(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    String _elementTypesQualifiedClassName = it.getDiagram().getElementTypesQualifiedClassName();
    _builder.append(_elementTypesQualifiedClassName);
    _builder.append(".");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier);
    return _builder;
  }
  
  @Override
  public CharSequence caseElementType(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _caseVisualID = this.xptVisualIDRegistry.caseVisualID(it);
    _builder.append(_caseVisualID);
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("return ");
    String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
    _builder.append(_stringUniqueIdentifier, "\t");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  @Override
  public CharSequence addKnownElementType(final GenCommonBase it) {
    StringConcatenation _builder = new StringConcatenation();
    {
      ElementType _elementType = it.getElementType();
      boolean _notEquals = (!Objects.equal(null, _elementType));
      if (_notEquals) {
        _builder.append("KNOWN_ELEMENT_TYPES.add(");
        String _stringUniqueIdentifier = this._common.stringUniqueIdentifier(it);
        _builder.append(_stringUniqueIdentifier);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
}
