/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.sync.internal;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.utils.TransactionHelper;
import org.eclipse.papyrus.infra.sync.EMFListener;
import org.eclipse.papyrus.infra.sync.SyncFeature;
import org.eclipse.papyrus.infra.sync.policy.ISyncPolicyDelegate;

class SyncPolicyDelegateRegistryImpl
implements ISyncPolicyDelegate.Registry {
    private ConcurrentMap<Class<? extends SyncFeature>, ISyncPolicyDelegate<?, ?>> delegates = new MapMaker().weakKeys().makeMap();
    private EMFListener listener;

    SyncPolicyDelegateRegistryImpl(TransactionalEditingDomain domain) {
        this.listener = this.createEMFListener(domain);
    }

    void dispose() {
        this.delegates.clear();
        if (this.listener != null) {
            this.listener.dispose();
            this.listener = null;
        }
    }

    EMFListener getEMFListener() {
        return this.listener;
    }

    @Override
    public <M, T> ISyncPolicyDelegate<M, T> get(SyncFeature<M, T, ?> syncFeature) {
        return (ISyncPolicyDelegate)this.delegates.get(syncFeature.getClass());
    }

    @Override
    public void register(ISyncPolicyDelegate<?, ?> policyDelegate, Class<?> featureType) {
        this.delegates.putIfAbsent(featureType.asSubclass(SyncFeature.class), policyDelegate);
    }

    @Override
    public void deregister(ISyncPolicyDelegate<?, ?> policyDelegate, Class<?> featureType) {
        this.delegates.remove(featureType.asSubclass(SyncFeature.class), policyDelegate);
    }

    private EMFListener createEMFListener(TransactionalEditingDomain domain) {
        return new EMFListener(domain){

            @Override
            public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                Transaction transaction = event.getTransaction();
                return transaction != null && TransactionHelper.isTriggerTransaction((Transaction)transaction) ? null : super.transactionAboutToCommit(event);
            }
        };
    }
}

