/**
 * Copyright (c) 2007, 2021 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Artem Tikhomirov (Borland) - initial API and implementation
 * Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : 1.4 Merge papyrus extension templates into codegen.xtend
 */
package xpt;

import com.google.inject.Singleton;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenEditorGenerator;

@Singleton
@SuppressWarnings("all")
public class GenEditorGenerator_qvto {
  /**
   * FIXME remove java-only GenEditorGenerator#hasAudits or declare it in metamodel
   */
  public boolean hasAudits(final GenEditorGenerator editorGen) {
    return ((editorGen.getAudits() != null) && (!editorGen.getAudits().getRules().isEmpty()));
  }

  /**
   * Returns java version number.
   * 
   * @returns 4 for Java1.4, 5 for JDK 5.0, 6 for JDK6.0 and 7 for JDK7.0, etc.
   */
  public int jdkComplianceLevel(final GenEditorGenerator xptSelf) {
    int _xblockexpression = (int) 0;
    {
      GenJDKLevel _xifexpression = null;
      if (((xptSelf == null) || (xptSelf.getJdkComplianceLevel() == null))) {
        _xifexpression = GenJDKLevel.JDK110_LITERAL;
      } else {
        _xifexpression = xptSelf.getJdkComplianceLevel();
      }
      GenJDKLevel l = _xifexpression;
      int _switchResult = (int) 0;
      if (l != null) {
        switch (l) {
          case JDK14_LITERAL:
            _switchResult = 4;
            break;
          default:
            _switchResult = Double.valueOf(l.getLiteral()).intValue();
            break;
        }
      } else {
        _switchResult = Double.valueOf(l.getLiteral()).intValue();
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }

  public int jdkComplianceLevel(final GenCommonBase xptSelf) {
    return this.jdkComplianceLevel(xptSelf.getDiagram().getEditorGen());
  }
}
