/**
 * Copyright (c) 2008, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Artem Tikhomirov (Borland) - initial API and implementation
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 *    Aurelien Didier (ARTAL) - aurelien.didier51@gmail.com - Bug 569174
 *    Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up
 */
package impl.preferences;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomPreferencePage;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenPreference;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.MetaDef;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import xpt.Common;

@Singleton
@SuppressWarnings("all")
public class CustomPage {
  @Inject
  @Extension
  private Common _common;

  protected String computePackageName(final GenCustomPreferencePage it) {
    String _qualifiedClassName = it.getQualifiedClassName();
    String _className = it.getClassName();
    boolean _equals = Objects.equal(_qualifiedClassName, _className);
    if (_equals) {
      return it.getDiagram().getPreferencesPackageName();
    } else {
      String _qualifiedClassName_1 = it.getQualifiedClassName();
      int _length = it.getQualifiedClassName().length();
      int _length_1 = it.getClassName().length();
      int _minus = (_length - _length_1);
      int _length_2 = ".".length();
      int _minus_1 = (_minus - _length_2);
      return _qualifiedClassName_1.substring(0, _minus_1);
    }
  }

  public CharSequence className(final GenCustomPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    String _className = it.getClassName();
    _builder.append(_className);
    return _builder;
  }

  public CharSequence packageName(final GenCustomPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    String _computePackageName = this.computePackageName(it);
    _builder.append(_computePackageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenCustomPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence Main(final GenCustomPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getDiagram().getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" ");
    CharSequence _implementsList = this.implementsList(it);
    _builder.append(_implementsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      EList<GenPreference> _preferences = it.getPreferences();
      for(final GenPreference pref : _preferences) {
        _builder.append("\t");
        CharSequence _constant = this.constant(pref);
        _builder.append(_constant, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    _builder.append("\t");
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("public ");
    CharSequence _className_1 = this.className(it);
    _builder.append(_className_1, "\t");
    _builder.append("() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("setPreferenceStore(");
    String _activatorQualifiedClassName = it.getDiagram().getEditorGen().getPlugin().getActivatorQualifiedClassName();
    _builder.append(_activatorQualifiedClassName, "\t\t");
    _builder.append(".getInstance().getPreferenceStore());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _methods = this.methods(it);
    _builder.append(_methods, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    CharSequence _initDefaultsMethod = this.initDefaultsMethod(it);
    _builder.append(_initDefaultsMethod, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence extendsList(final GenCustomPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.runtime.common.ui.preferences.AbstractPreferencePage");
    return _builder;
  }

  public CharSequence implementsList(final GenCustomPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    return _builder;
  }

  /**
   * [artem]: the reason I didn't split this template up into two distinct, addFieldsMethod and initHelpMethod, is that
   * using super class other than oe.gmf...AbstractPreferencePage may require implementation of completely different
   * set of methods. Besides, there's not to much generated, anyway.
   */
  public CharSequence methods(final GenCustomPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void addFields(org.eclipse.swt.widgets.Composite parent) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// TODO  Provide method implementation");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("throw new UnsupportedOperationException();");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generatedMemberComment_1 = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment_1);
    _builder.newLineIfNotEmpty();
    _builder.append("protected void initHelp() {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// TODO implement this method if needed, or leave as no-op");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence initDefaultsMethod(final GenCustomPreferencePage it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static void initDefaults(org.eclipse.jface.preference.IPreferenceStore store) {");
    _builder.newLine();
    {
      if ((it.getPreferences().isEmpty() || IterableExtensions.<GenPreference>exists(it.getPreferences(), ((Function1<GenPreference, Boolean>) (GenPreference p) -> {
        String _defaultValue = p.getDefaultValue();
        return Boolean.valueOf((_defaultValue == null));
      })))) {
        _builder.append("\t");
        _builder.append("// TODO this code is invoked during preference store initialization, please fill");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("// the store passed with default preference values.");
        _builder.newLine();
      }
    }
    {
      final Function1<GenPreference, Boolean> _function = (GenPreference p) -> {
        String _defaultValue = p.getDefaultValue();
        return Boolean.valueOf((_defaultValue != null));
      };
      Iterable<GenPreference> _filter = IterableExtensions.<GenPreference>filter(it.getPreferences(), _function);
      for(final GenPreference pref : _filter) {
        _builder.append("\t");
        CharSequence _setDefaultValue = this.setDefaultValue(pref, "store");
        _builder.append(_setDefaultValue, "\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  /**
   * pair template to initDefaultsMethod, allows external templates invoke generated initDefaults method
   * Note, CustomPage::Main is expected to be invoked only for templates with generateBoilerplate == true,
   * hence no extra check when generating with initDefaultsMethod,
   * however, call_initDefaults may get invoked for any CustomPreferencePage
   */
  @MetaDef
  public CharSequence call_initDefaults(final GenCustomPreferencePage it, final String storeVarName) {
    StringConcatenation _builder = new StringConcatenation();
    {
      boolean _isGenerateBoilerplate = it.isGenerateBoilerplate();
      if (_isGenerateBoilerplate) {
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append(_qualifiedClassName);
        _builder.append(".initDefaults(");
        _builder.append(storeVarName);
        _builder.append(");");
      }
    }
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence constant(final GenPreference it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public static final String ");
    String _name = it.getName();
    _builder.append(_name);
    _builder.append(" = \"");
    String _key = it.getKey();
    _builder.append(_key);
    _builder.append("\"; ");
    CharSequence _nonNLS = this._common.nonNLS(1);
    _builder.append(_nonNLS);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  public CharSequence setDefaultValue(final GenPreference it, final String store) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(store);
    _builder.append(".setDefault(");
    String _name = it.getName();
    _builder.append(_name);
    _builder.append(", ");
    String _defaultValue = it.getDefaultValue();
    _builder.append(_defaultValue);
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
