/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class SequenceInternalSourceToRepresentationDropChecker
implements IInternalSourceToRepresentationDropChecker {
    private static final String DROP_ERROR_MSG = "{0} can only be drag and drop on {1}.";
    private static final String COMA = ", ";

    @Override
    public CheckStatus canDragAndDrop(EObject elementToDrop, EObject newSemanticContainer) {
        return (CheckStatus)new SequenceDropOutsideRepresentationCheckerSwitch(newSemanticContainer).doSwitch(elementToDrop);
    }

    static class SequenceDropOutsideRepresentationCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private EObject newSemanticContainer;

        SequenceDropOutsideRepresentationCheckerSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public CheckStatus caseComment(Comment comment) {
            CheckStatus result = this.newSemanticContainer instanceof Interaction || this.newSemanticContainer instanceof InteractionOperand ? CheckStatus.YES : CheckStatus.no(MessageFormat.format(SequenceInternalSourceToRepresentationDropChecker.DROP_ERROR_MSG, comment.eClass().getName(), UMLPackage.eINSTANCE.getInteraction().getName() + SequenceInternalSourceToRepresentationDropChecker.COMA + UMLPackage.eINSTANCE.getInteractionOperand().getName()));
            return result;
        }

        public CheckStatus caseConstraint(Constraint constraint) {
            CheckStatus result = this.newSemanticContainer instanceof Interaction || this.newSemanticContainer instanceof InteractionOperand ? CheckStatus.YES : CheckStatus.no(MessageFormat.format(SequenceInternalSourceToRepresentationDropChecker.DROP_ERROR_MSG, constraint.eClass().getName(), UMLPackage.eINSTANCE.getInteraction().getName() + SequenceInternalSourceToRepresentationDropChecker.COMA + UMLPackage.eINSTANCE.getInteractionOperand().getName()));
            return result;
        }
    }
}

