/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.drop.IInternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.internal.helpers.ActivityEdgeHelper;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.papyrus.uml.domain.services.status.State;
import org.eclipse.papyrus.uml.domain.services.status.Status;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityGroup;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InterruptibleActivityRegion;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ActivityInternalSourceToRepresentationDropBehaviorProvider
implements IInternalSourceToRepresentationDropBehaviorProvider {
    @Override
    public Status drop(EObject droppedElement, EObject oldContainer, EObject newContainer, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return (Status)new ActivityDropOutsideRepresentationBehaviorProviderSwitch(oldContainer, newContainer, crossRef, editableChecker).doSwitch(droppedElement);
    }

    static class ActivityDropOutsideRepresentationBehaviorProviderSwitch
    extends UMLSwitch<Status> {
        private final EObject oldContainer;
        private final EObject newContainer;
        private final ECrossReferenceAdapter crossRef;
        private final IEditableChecker editableChecker;

        ActivityDropOutsideRepresentationBehaviorProviderSwitch(EObject oldContainer, EObject newContainer, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
            this.oldContainer = oldContainer;
            this.newContainer = newContainer;
            this.crossRef = crossRef;
            this.editableChecker = editableChecker;
        }

        public Status caseActivityPartition(ActivityPartition droppedActivityPartition) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                Status dropStatus;
                EObject eObject = this.newContainer;
                if (eObject instanceof Activity) {
                    Activity newActivity = (Activity)eObject;
                    dropStatus = this.updateActivityPartitionContent(droppedActivityPartition, newActivity);
                    if (State.DONE == dropStatus.getState()) {
                        dropStatus = modifier.addValue((EObject)newActivity, UMLPackage.eINSTANCE.getActivity_Partition().getName(), droppedActivityPartition);
                    }
                } else {
                    EObject eObject2 = this.newContainer;
                    if (eObject2 instanceof ActivityPartition) {
                        ActivityPartition newPartition = (ActivityPartition)eObject2;
                        Activity newActivityContainer = this.findActivity((EObject)newPartition);
                        dropStatus = this.oldContainer != newActivityContainer ? this.updateActivityPartitionContent(droppedActivityPartition, newActivityContainer) : Status.DONE;
                        if (State.DONE == dropStatus.getState()) {
                            dropStatus = modifier.addValue((EObject)newPartition, UMLPackage.eINSTANCE.getActivityPartition_Subpartition().getName(), droppedActivityPartition);
                        }
                    } else {
                        dropStatus = Status.createFailingStatus("An ActivityPartition can only be dropped in an Activity or ActivityPartition");
                    }
                }
                return dropStatus;
            }
            return (Status)super.caseActivityPartition(droppedActivityPartition);
        }

        private ActivityPartitionContent findPartitionContentContainedInActivity(ActivityPartition activityPartition) {
            Activity partitionActivity = this.findActivity((EObject)activityPartition);
            ActivityPartitionContent partitionContent = new ActivityPartitionContent(new ArrayList<ActivityNode>(), new ArrayList<ActivityEdge>());
            partitionContent.addPartitionContent(activityPartition, partitionActivity);
            for (ActivityPartition subpartition : activityPartition.getSubpartitions()) {
                partitionContent.addAll(this.findPartitionContentContainedInActivity(subpartition));
            }
            return partitionContent;
        }

        private Status updateActivityPartitionContent(ActivityPartition droppedActivityPartition, Activity newActivity) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            ActivityPartitionContent allPartitionContent = this.findPartitionContentContainedInActivity(droppedActivityPartition);
            Status newStatus = Status.createOKStatus((EObject)droppedActivityPartition);
            for (ActivityNode node : allPartitionContent.activityNodes) {
                if (State.FAILED == newStatus.getState()) break;
                newStatus = modifier.addValue((EObject)newActivity, UMLPackage.eINSTANCE.getActivity_OwnedNode().getName(), node);
            }
            for (ActivityEdge edge : allPartitionContent.activityEdges) {
                if (State.FAILED == newStatus.getState()) break;
                newStatus = modifier.addValue((EObject)newActivity, UMLPackage.eINSTANCE.getActivity_Edge().getName(), edge);
            }
            return newStatus;
        }

        public Status caseActivityNode(ActivityNode droppedActivityNode) {
            if (this.oldContainer != this.newContainer) {
                return this.handleActivityNode(droppedActivityNode, (EStructuralFeature)UMLPackage.eINSTANCE.getActivity_OwnedNode());
            }
            return (Status)super.caseActivityNode(droppedActivityNode);
        }

        private Status handleActivityNode(ActivityNode droppedActivityNode, EStructuralFeature parentActivityContainmentFeature) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            Status dropStatus = this.oldContainer instanceof Activity ? modifier.removeValue(this.oldContainer, parentActivityContainmentFeature.getName(), droppedActivityNode) : (this.oldContainer instanceof ActivityGroup && !(this.oldContainer instanceof StructuredActivityNode) ? this.removeActivityNodeInActivityGroup((ActivityGroup)this.oldContainer, droppedActivityNode) : (this.oldContainer instanceof StructuredActivityNode ? modifier.removeValue(this.oldContainer, UMLPackage.eINSTANCE.getStructuredActivityNode_Node().getName(), droppedActivityNode) : Status.createFailingStatus(MessageFormat.format("The old container could not be modified, its type is not managed when dragging and dropping {0}.", droppedActivityNode.eClass().getName()))));
            if (State.DONE == dropStatus.getState()) {
                dropStatus = this.newContainer instanceof Activity ? modifier.addValue(this.newContainer, parentActivityContainmentFeature.getName(), droppedActivityNode) : (this.newContainer instanceof ActivityGroup && !(this.newContainer instanceof StructuredActivityNode) ? this.addActivityNodeInActivityGroup((ActivityGroup)this.newContainer, droppedActivityNode, parentActivityContainmentFeature) : (this.newContainer instanceof StructuredActivityNode ? modifier.addValue(this.newContainer, UMLPackage.eINSTANCE.getStructuredActivityNode_Node().getName(), droppedActivityNode) : Status.createFailingStatus(MessageFormat.format("The new container could not be modified, its type is not managed when dragging and dropping {0}.", droppedActivityNode.eClass().getName()))));
            }
            this.updateActivityEdgesFromActivityNode(droppedActivityNode, dropStatus);
            return dropStatus;
        }

        public Status caseElement(Element droppedElement) {
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (this.oldContainer != this.newContainer) {
                String refName = droppedElement.eContainmentFeature().getName();
                if (this.oldContainer.eClass().getEStructuralFeature(refName) != null && this.newContainer.eClass().getEStructuralFeature(refName) != null) {
                    Status dropStatus = modifier.removeValue(this.oldContainer, refName, droppedElement);
                    if (State.DONE == dropStatus.getState()) {
                        dropStatus = modifier.addValue(this.newContainer, refName, droppedElement);
                    }
                    return dropStatus;
                }
            }
            return (Status)super.caseElement(droppedElement);
        }

        public Status caseStructuredActivityNode(StructuredActivityNode droppedStructuredActivityNode) {
            if (this.oldContainer != this.newContainer) {
                return this.handleActivityNode((ActivityNode)droppedStructuredActivityNode, (EStructuralFeature)UMLPackage.eINSTANCE.getActivity_StructuredNode());
            }
            return (Status)super.caseStructuredActivityNode(droppedStructuredActivityNode);
        }

        private void updateActivityEdgesFromActivityNode(ActivityNode droppedActivityNode, Status dropStatus) {
            if (State.DONE == dropStatus.getState()) {
                ActivityEdgeHelper activityEdgeHelper = new ActivityEdgeHelper();
                Set<ActivityEdge> allEdges = activityEdgeHelper.getAllActivityEdgesFromActivityNode(droppedActivityNode);
                for (ActivityEdge activityEdge : allEdges) {
                    activityEdgeHelper.updateActivityEdgeContainer(activityEdge);
                    activityEdgeHelper.setInPartition(activityEdge);
                }
            }
        }

        private Status removeActivityNodeInActivityGroup(ActivityGroup container, ActivityNode droppedActivityNode) {
            Status dropStatus;
            Activity parentActivity = this.findActivity((EObject)container);
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (parentActivity != null) {
                dropStatus = modifier.removeValue((EObject)parentActivity, UMLPackage.eINSTANCE.getActivity_OwnedNode().getName(), droppedActivityNode);
                String featureName = null;
                if (State.DONE == dropStatus.getState()) {
                    if (container instanceof ActivityPartition) {
                        featureName = UMLPackage.eINSTANCE.getActivityPartition_Node().getName();
                    } else if (container instanceof InterruptibleActivityRegion) {
                        featureName = UMLPackage.eINSTANCE.getInterruptibleActivityRegion_Node().getName();
                    }
                    if (featureName != null) {
                        modifier.removeValue((EObject)container, featureName, droppedActivityNode);
                    }
                }
            } else {
                dropStatus = Status.createFailingStatus(MessageFormat.format("The {0} \"{1}\" container doesn't have any associated Activity container.", container.eClass().getName(), container.getName()));
            }
            return dropStatus;
        }

        private Status addActivityNodeInActivityGroup(ActivityGroup container, ActivityNode droppedActivityNode, EStructuralFeature parentActivityContainmentFeature) {
            Status dropStatus;
            Activity parentActivity = this.findActivity((EObject)container);
            ElementFeatureModifier modifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
            if (parentActivity != null) {
                dropStatus = modifier.addValue((EObject)parentActivity, parentActivityContainmentFeature.getName(), droppedActivityNode);
                String featureName = null;
                if (State.DONE == dropStatus.getState()) {
                    if (container instanceof ActivityPartition) {
                        featureName = UMLPackage.eINSTANCE.getActivityPartition_Node().getName();
                    } else if (container instanceof InterruptibleActivityRegion) {
                        featureName = UMLPackage.eINSTANCE.getInterruptibleActivityRegion_Node().getName();
                    }
                    if (featureName != null) {
                        modifier.addValue((EObject)container, featureName, droppedActivityNode);
                    }
                }
            } else {
                dropStatus = Status.createFailingStatus(MessageFormat.format("The {0} \"{1}\" container doesn't have any associated Activity container.", container.eClass().getName(), container.getName()));
            }
            return dropStatus;
        }

        public Status defaultCase(EObject object) {
            return Status.createFailingStatus("Drag and Drop operation could not be performed.");
        }

        private Activity findActivity(EObject editElement) {
            Activity container = null;
            if (editElement instanceof ActivityGroup) {
                ActivityGroup activityGroup = (ActivityGroup)editElement;
                container = activityGroup.eContainer() instanceof Activity ? (Activity)activityGroup.eContainer() : this.findActivity(activityGroup.eContainer());
            }
            return container;
        }

        record ActivityPartitionContent(List<ActivityNode> activityNodes, List<ActivityEdge> activityEdges) {
            public void addAll(ActivityPartitionContent partitionContent) {
                this.activityNodes.addAll(partitionContent.activityNodes);
                this.activityEdges.addAll(partitionContent.activityEdges);
            }

            public void addPartitionContent(ActivityPartition partition, Activity partitionActivity) {
                List nodesContainedInActivity = partition.getNodes().stream().filter(node -> node.getOwner().equals(partitionActivity)).collect(Collectors.toList());
                List edgesContainedInActivity = partition.getEdges().stream().filter(edge -> edge.getOwner().equals(partitionActivity)).collect(Collectors.toList());
                this.activityNodes.addAll(nodesContainedInActivity);
                this.activityEdges.addAll(edgesContainedInActivity);
            }
        }
    }
}

