/**
 * Copyright (c) 2007, 2020 Borland Software Corporation, CEA LIST, Artal and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * 	Dmitry Stadnik (Borland) - initial API and implementation
 * 	Michael Golubev (Borland) - #244970 (GenChildLabelNode can't be link's source/target)
 * 	  Michael Golubev (Montages) - #386838 - migrate to Xtend2
 * 	Etienne Allogo (ARTAL) - etienne.allogo@artal.fr - Bug 569174 : L1.2 clean up providers
 */
package xpt.providers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.papyrus.gmf.codegen.xtend.annotations.Localization;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import plugin.Activator;
import xpt.CodeStyle;
import xpt.Common;
import xpt.Externalizer;
import xpt.ExternalizerUtils_qvto;

@Singleton
@SuppressWarnings("all")
public class ModelingAssistantProvider {
  @Inject
  @Extension
  private Common _common;

  @Inject
  @Extension
  private ExternalizerUtils_qvto _externalizerUtils_qvto;

  @Inject
  @Extension
  private CodeStyle _codeStyle;

  @Inject
  private Activator xptActivator;

  @Inject
  private Externalizer xptExternalizer;

  public CharSequence className(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _modelingAssistantProviderClassName = it.getModelingAssistantProviderClassName();
    _builder.append(_modelingAssistantProviderClassName);
    return _builder;
  }

  public CharSequence packageName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    String _providersPackageName = it.getProvidersPackageName();
    _builder.append(_providersPackageName);
    return _builder;
  }

  public CharSequence qualifiedClassName(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(".");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    return _builder;
  }

  public CharSequence fullPath(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _qualifiedClassName = this.qualifiedClassName(it);
    _builder.append(_qualifiedClassName);
    return _builder;
  }

  public CharSequence extendsList(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("extends org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantProvider");
    return _builder;
  }

  public CharSequence ModelingAssistantProvider(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _copyright = this._common.copyright(it.getEditorGen());
    _builder.append(_copyright);
    _builder.newLineIfNotEmpty();
    _builder.append("package ");
    CharSequence _packageName = this.packageName(it);
    _builder.append(_packageName);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    CharSequence _generatedClassComment = this._common.generatedClassComment();
    _builder.append(_generatedClassComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public class ");
    CharSequence _className = this.className(it);
    _builder.append(_className);
    _builder.append(" ");
    CharSequence _extendsList = this.extendsList(it);
    _builder.append(_extendsList);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _selectExistingElementForSource = this.selectExistingElementForSource(it);
    _builder.append(_selectExistingElementForSource, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _selectExistingElementForTarget = this.selectExistingElementForTarget(it);
    _builder.append(_selectExistingElementForTarget, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _selectExistingElement = this.selectExistingElement(it);
    _builder.append(_selectExistingElement, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _isApplicableElement = this.isApplicableElement(it);
    _builder.append(_isApplicableElement, "\t");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    CharSequence _selectElement = this.selectElement(it);
    _builder.append(_selectElement, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence selectExistingElementForSource(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.emf.ecore.EObject selectExistingElementForSource(org.eclipse.core.runtime.IAdaptable target, org.eclipse.gmf.runtime.emf.type.core.IElementType relationshipType) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return selectExistingElement(target, getTypesForSource(target, relationshipType));");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence selectExistingElementForTarget(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("public org.eclipse.emf.ecore.EObject selectExistingElementForTarget(org.eclipse.core.runtime.IAdaptable source, org.eclipse.gmf.runtime.emf.type.core.IElementType relationshipType) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return selectExistingElement(source, getTypesForTarget(source, relationshipType));");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence selectExistingElement(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.emf.ecore.EObject selectExistingElement(org.eclipse.core.runtime.IAdaptable host, java.util.Collection types) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (types.isEmpty()) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart editPart =");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("host.getAdapter(org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart.class);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (editPart == null) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.notation.Diagram diagram =");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("(org.eclipse.gmf.runtime.notation.Diagram) editPart.getRoot().getContents().getModel();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("java.util.HashSet<org.eclipse.emf.ecore.EObject> elements = new java.util.HashSet<");
    String _diamondOp = this._codeStyle.diamondOp(it, "org.eclipse.emf.ecore.EObject");
    _builder.append(_diamondOp, "\t");
    _builder.append(">();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("for (java.util.Iterator<org.eclipse.emf.ecore.EObject> it = diagram.getElement().eAllContents(); it.hasNext();) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EObject element = it.next();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (isApplicableElement(element, types)) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("elements.add(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (elements.isEmpty()) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return selectElement((org.eclipse.emf.ecore.EObject[]) elements.toArray(new org.eclipse.emf.ecore.EObject[elements.size()]));");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence isApplicableElement(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected boolean isApplicableElement(org.eclipse.emf.ecore.EObject element, java.util.Collection types) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.IElementType type =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry.getInstance().getElementType(element);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return types.contains(type);");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence selectElement(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _generatedMemberComment = this._common.generatedMemberComment();
    _builder.append(_generatedMemberComment);
    _builder.newLineIfNotEmpty();
    _builder.append("protected org.eclipse.emf.ecore.EObject selectElement(org.eclipse.emf.ecore.EObject[] elements) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.swt.widgets.Shell shell = org.eclipse.swt.widgets.Display.getCurrent().getActiveShell();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.jface.viewers.ILabelProvider labelProvider =");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("new org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider(");
    CharSequence _qualifiedClassName = this.xptActivator.qualifiedClassName(it.getEditorGen().getPlugin());
    _builder.append(_qualifiedClassName, "\t\t");
    _builder.append(".getInstance().getItemProvidersAdapterFactory());");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("org.eclipse.ui.dialogs.ElementListSelectionDialog dialog =");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("new org.eclipse.ui.dialogs.ElementListSelectionDialog(shell, labelProvider);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("dialog.setMessage(");
    CharSequence _accessorCall = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.messageKey(this.i18nKeyForModelingAssistantProvider(it)));
    _builder.append(_accessorCall, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("dialog.setTitle(");
    CharSequence _accessorCall_1 = this.xptExternalizer.accessorCall(it.getEditorGen(), this._externalizerUtils_qvto.titleKey(this.i18nKeyForModelingAssistantProvider(it)));
    _builder.append(_accessorCall_1, "\t");
    _builder.append(");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("dialog.setMultipleSelection(false);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("dialog.setElements(elements);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("org.eclipse.emf.ecore.EObject selected = null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("if (dialog.open() == org.eclipse.jface.window.Window.OK) {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("selected = (org.eclipse.emf.ecore.EObject) dialog.getFirstResult();");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("return selected;");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }

  public CharSequence newArrayListOfElementTypes(final GenCommonBase it, final String varName) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("java.util.ArrayList<org.eclipse.gmf.runtime.emf.type.core.IElementType> ");
    _builder.append(varName);
    _builder.append(" = new java.util.ArrayList<");
    String _diamondOp = this._codeStyle.diamondOp(it, "org.eclipse.gmf.runtime.emf.type.core.IElementType");
    _builder.append(_diamondOp);
    _builder.append(">");
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  protected String i18nKeyForModelingAssistantProvider(final GenDiagram it) {
    CharSequence _className = this.className(it);
    return ("" + _className);
  }

  @Localization
  public CharSequence i18nValues(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _messageEntry = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.titleKey(this.i18nKeyForModelingAssistantProvider(it)), "Select domain model element");
    _builder.append(_messageEntry);
    _builder.newLineIfNotEmpty();
    CharSequence _messageEntry_1 = this.xptExternalizer.messageEntry(this._externalizerUtils_qvto.messageKey(this.i18nKeyForModelingAssistantProvider(it)), "Available domain model elements:");
    _builder.append(_messageEntry_1);
    _builder.newLineIfNotEmpty();
    return _builder;
  }

  @Localization
  public CharSequence i18nAccessors(final GenDiagram it) {
    StringConcatenation _builder = new StringConcatenation();
    CharSequence _accessorField = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.titleKey(this.i18nKeyForModelingAssistantProvider(it)));
    _builder.append(_accessorField);
    _builder.newLineIfNotEmpty();
    CharSequence _accessorField_1 = this.xptExternalizer.accessorField(this._externalizerUtils_qvto.messageKey(this.i18nKeyForModelingAssistantProvider(it)));
    _builder.append(_accessorField_1);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
