/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.bundles.tests;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.internal.bundles.tests.PapyrusBundleDescription;
import org.osgi.framework.Bundle;

public final class PapyrusBundleDescriptionRegistry {
    private final Map<String, PapyrusBundleDescription> loadedBundlesCache = new HashMap<String, PapyrusBundleDescription>();
    public static final PapyrusBundleDescriptionRegistry INSTANCE = new PapyrusBundleDescriptionRegistry();

    public final PapyrusBundleDescription getPapyrusBundleDescription(String bundleName) {
        Bundle bundle;
        if (bundleName != null && (bundle = Platform.getBundle((String)bundleName)) != null) {
            if (this.loadedBundlesCache.get(bundleName) == null) {
                this.loadedBundlesCache.put(bundleName, new PapyrusBundleDescription(bundleName));
            }
            return this.loadedBundlesCache.get(bundleName);
        }
        return null;
    }

    public final void clearRegistry() {
        this.loadedBundlesCache.clear();
    }

    private PapyrusBundleDescriptionRegistry() {
    }
}

