/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.properties.toolsmiths.editor.actions;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.CommandActionDelegate;
import org.eclipse.papyrus.views.properties.toolsmiths.Activator;

public class CreateResourceCommand
extends AbstractCommand
implements CommandActionDelegate {
    private EObject object;
    private URI uri;
    private ResourceSet resourceSet;
    private boolean fileAlreadyExists = true;
    private Resource resource;

    public CreateResourceCommand(EObject object, URI uri, ResourceSet resourceSet) {
        super("Create new " + object.eClass().getName(), "Creates a new " + object.eClass().getName());
        this.object = object;
        this.uri = uri;
        this.resourceSet = resourceSet;
    }

    public void execute() {
        this.resource = this.resourceSet.getResource(this.uri, false);
        if (this.resource == null) {
            Activator.log.debug("+++ Creating " + String.valueOf(this.uri));
            this.fileAlreadyExists = false;
            this.resource = this.resourceSet.createResource(this.uri);
        } else {
            Activator.log.debug("+++ " + String.valueOf(this.resource.getURI()) + " already exists");
        }
        this.resource.getContents().add((Object)this.object);
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        if (!this.fileAlreadyExists) {
            Activator.log.debug("--- Deleting " + String.valueOf(this.resource.getURI()));
            try {
                this.resourceSet.getResources().remove((Object)this.resource);
                this.resource.delete(Collections.emptyMap());
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
            }
        } else {
            Activator.log.debug("--- " + String.valueOf(this.resource.getURI()) + " will not be deleted");
        }
    }

    public Object getImage() {
        return null;
    }

    public String getText() {
        return this.getLabel();
    }

    public String getToolTipText() {
        return this.getDescription();
    }

    protected boolean prepare() {
        return true;
    }
}

