/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.util;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.constraints.environment.ConstraintType;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.properties.contexts.Context;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.infra.properties.contexts.Section;
import org.eclipse.papyrus.infra.properties.contexts.Tab;
import org.eclipse.papyrus.infra.properties.contexts.View;
import org.eclipse.papyrus.infra.properties.environment.Environment;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.ComposedSourceTraceHelper;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.trace.SourceTraceHelper;
import org.eclipse.uml2.common.util.CacheAdapter;

public class PropertiesCache {
    static final PropertiesCache INSTANCE = new PropertiesCache();
    private final Map<?, ?> cacheMisses;
    private final Map<?, ?> defaults;
    private final Object contextKey = URI.createURI((String)"PropertiesCache:context");
    private final Object sourceKey = URI.createURI((String)"PropertiesCache:source");
    private final Object nameKey = URI.createURI((String)"PropertiesCache:name");
    private final Object nestedPackagesKey = URI.createURI((String)"PropertiesCache:nestedPackages");
    private final Object classesKey = URI.createURI((String)"PropertiesCache:classes");
    private final Object propertiesKey = URI.createURI((String)"PropertiesCache:properties");
    private final Object isPropertyRedefinitionKey = URI.createURI((String)"PropertiesCache:isPropertyRedefinition");
    private final Object superclassesKey = URI.createURI((String)"PropertiesCache:superclasses");
    private final Object viewsKey = URI.createURI((String)"PropertiesCache:views");
    private final Object sectionsKey = URI.createURI((String)"PropertiesCache:sections");
    private final Object constraintTypesKey = URI.createURI((String)"constraintTypes");
    private final Object allDataContextElementsKey = new Object();
    private final SourceTraceHelper sourceTraceHelper = new ComposedSourceTraceHelper();

    private PropertiesCache() {
        EObject dummy = EcoreFactory.eINSTANCE.createEObject();
        this.cacheMisses = Map.of(this.sourceKey, dummy, this.classesKey, List.of(dummy), this.propertiesKey, List.of(dummy));
        this.defaults = Map.of(this.classesKey, List.of(), this.propertiesKey, List.of());
    }

    public static PropertiesCache getInstance(Notifier notifier) {
        return INSTANCE;
    }

    private static CacheAdapter getCacheAdapter(EObject object) {
        return CacheAdapter.getInstance();
    }

    public Context getContext(EObject contextElement) {
        return this.getOrCache(contextElement, this.contextKey, e -> {
            EObject root = EcoreUtil.getRootContainer((EObject)e);
            return root instanceof Context ? (Context)root : null;
        });
    }

    public EObject getSourceElement(EObject propertiesElement) {
        return this.getOrCache(propertiesElement, this.sourceKey, this.sourceTraceHelper::getSourceElement);
    }

    public String getName(EObject sourceElement) {
        return this.getOrCache(sourceElement, this.nameKey, this.sourceTraceHelper::getName);
    }

    public List<? extends EObject> getNestedPackages(EObject sourcePackage) {
        return this.getOrCache(sourcePackage, this.nestedPackagesKey, this.sourceTraceHelper::getNestedPackages);
    }

    public List<? extends EObject> getClasses(EObject sourcePackage) {
        return this.getOrCache(sourcePackage, this.classesKey, this.sourceTraceHelper::getClasses);
    }

    public List<DataContextElement> getDataContextElements(Context context) {
        return this.getOrCache(context, this.allDataContextElementsKey, this::getAllDataContextElements);
    }

    private List<DataContextElement> getAllDataContextElements(Context context) {
        ImmutableList.Builder result = ImmutableList.builder();
        ResourceSet rset = EMFHelper.getResourceSet((EObject)context);
        TreeIterator contents = rset.getAllContents();
        while (contents.hasNext()) {
            Object next = contents.next();
            if (next instanceof DataContextElement) {
                result.add((Object)((DataContextElement)next));
                continue;
            }
            if (!(next instanceof Tab) && !(next instanceof View)) continue;
            contents.prune();
        }
        return result.build();
    }

    public List<View> getViews(DataContextElement element) {
        return this.getOrCache(element, this.viewsKey, this::getViewsOf);
    }

    private List<View> getViewsOf(DataContextElement element) {
        return (List)this.allViews(this.getContext((EObject)element)).filter(view -> this.sourceTraceHelper.isViewOf((View)view, element)).collect(ImmutableList.toImmutableList());
    }

    private Stream<View> allViews(Context context) {
        return context.getViews().stream();
    }

    public List<Section> getSections(DataContextElement element) {
        return this.getOrCache(element, this.sectionsKey, this::getSectionsOf);
    }

    private List<Section> getSectionsOf(DataContextElement element) {
        return (List)this.allSections(this.getContext((EObject)element)).filter(section -> this.sourceTraceHelper.isSectionFor((Section)section, element)).collect(ImmutableList.toImmutableList());
    }

    private Stream<Section> allSections(Context context) {
        return context.getTabs().stream().map(Tab::getSections).flatMap(Collection::stream);
    }

    public Optional<DataContextElement> getDataContextElement(DataContextPackage package_, EObject sourceClass) {
        Context context = this.getContext((EObject)package_);
        return this.getDataContextElements(context).stream().filter(element -> this.getSourceElement((EObject)element) == sourceClass).findAny();
    }

    public List<? extends EObject> getProperties(EObject sourceClass) {
        return this.getOrCache(sourceClass, this.propertiesKey, this.sourceTraceHelper::getProperties);
    }

    public boolean isPropertyRedefinition(EObject sourceProperty) {
        return this.getOrCache(sourceProperty, this.isPropertyRedefinitionKey, this.sourceTraceHelper::isPropertyRedefinition);
    }

    public List<? extends EObject> getSuperclasses(EObject sourceClass) {
        return this.getOrCache(sourceClass, this.superclassesKey, this.sourceTraceHelper::getSuperclasses);
    }

    public List<ConstraintType> getConstraintTypes(Context context) {
        return this.getOrCache(context, this.constraintTypesKey, this::getAllConstraintTypes);
    }

    private List<ConstraintType> getAllConstraintTypes(Context context) {
        ImmutableList.Builder result = ImmutableList.builder();
        ResourceSet rset = EMFHelper.getResourceSet((EObject)context);
        for (Resource resource : rset.getResources()) {
            for (EObject root : resource.getContents()) {
                if (!(root instanceof Environment)) continue;
                result.addAll((Iterable)((Environment)root).getConstraintTypes());
            }
        }
        return result.build();
    }

    private <T extends EObject, V> V getOrCache(T object, Object key, Function<? super T, V> computer) {
        CacheAdapter cache = PropertiesCache.getCacheAdapter(object);
        Object result = cache.get(object, key);
        Object cacheMiss = this.cacheMisses.get(key);
        if (result == null) {
            result = computer.apply(object);
            if (result == null) {
                result = cacheMiss;
            }
            cache.put(object, key, result);
        }
        if (result == cacheMiss) {
            Object defaultValue = this.defaults.get(key);
            result = defaultValue;
        }
        return (V)result;
    }

    public <T extends EObject> EList<T> getReferencers(EObject object, EReference reference) {
        return (EList)PropertiesCache.getCacheAdapter(object).getInverseReferences(object).stream().filter(setting -> setting.getEStructuralFeature() == reference).map(EStructuralFeature.Setting::getEObject).collect(Collectors.toCollection(UniqueEList.FastCompare::new));
    }

    public Collection<EStructuralFeature.Setting> getInverseReferences(EObject object, EReference reference) {
        return (Collection)PropertiesCache.getCacheAdapter(object).getInverseReferences(object).stream().filter(setting -> setting.getEStructuralFeature() == reference).collect(Collectors.toCollection(UniqueEList.FastCompare::new));
    }

    public Collection<EStructuralFeature.Setting> getInverseReferences(EObject object) {
        return PropertiesCache.getCacheAdapter(object).getInverseReferences(object);
    }
}

