/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.toolbox.notification.view;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.ICallBack;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.INotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.IContext;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractInsideComposite
extends Composite {
    private final FormToolkit toolkit;
    private Section section;
    private Control previous;
    private Control after;
    private final ICallBack callback;
    protected IContext context = new IContext.Context();
    private Collection<NotificationRunnable> runnables;

    AbstractInsideComposite(ICallBack callback, ScrolledForm parent, FormToolkit toolkit, Collection<NotificationRunnable> collection) {
        super(parent.getBody(), 0);
        this.callback = callback;
        this.toolkit = toolkit;
        this.runnables = collection;
        this.createContents();
    }

    public void setINotification(INotification notification) {
        this.context.put("notification_object_please_check_IContext_Constant", notification);
    }

    private void createContents() {
        this.section = this.toolkit.createSection((Composite)this, 322);
        this.section.setText(this.getSectionName() + " - " + new SimpleDateFormat("HH'h'mm'm'ss's'").format(new Date()));
        this.section.setLayout((Layout)new FillLayout());
        Composite compo = this.toolkit.createComposite((Composite)this.section);
        compo.setLayout((Layout)new GridLayout(1, false));
        Control control = this.doCreateContents(this.toolkit, compo);
        control.setLayoutData((Object)new GridData(1808));
        this.createHyperLinkSection(compo);
        this.section.setClient((Control)compo);
    }

    protected void createHyperLinkSection(Composite compo) {
        Composite compoHL = this.toolkit.createComposite(compo);
        compoHL.setLayout((Layout)new FillLayout());
        if (this.runnables != null && !this.runnables.isEmpty()) {
            for (final NotificationRunnable r : this.runnables) {
                Button b = this.toolkit.createButton(compoHL, r.getLabel() == null ? "run" : r.getLabel(), 0);
                b.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractInsideComposite.this.run(r);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        AbstractInsideComposite.this.run(r);
                    }
                });
            }
        } else {
            Button b = this.toolkit.createButton(compoHL, "close", 0);
            b.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractInsideComposite.this.close();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    AbstractInsideComposite.this.close();
                }
            });
        }
        compoHL.setLayoutData((Object)new GridData(3, 3, false, true, 1, 1));
    }

    protected void setCompositeCreated(Composite c) {
        this.context.put("composite_created_please_check_IContext_Constant", c);
    }

    public void close() {
        this.callback.callBack((Object)this);
    }

    public void run(NotificationRunnable r) {
        if (r != null) {
            r.run(this.context);
            this.close();
        }
    }

    public void runDefault() {
        if (this.runnables != null && !this.runnables.isEmpty()) {
            this.runnables.iterator().next().run(this.context);
        }
        this.close();
    }

    public void expand() {
        this.section.setExpanded(true);
    }

    public void collapse() {
        this.section.setExpanded(false);
    }

    protected abstract Control doCreateContents(FormToolkit var1, Composite var2);

    protected abstract String getSectionName();

    public void setAfter(Control after) {
        this.after = after;
    }

    public Control getAfter() {
        return this.after;
    }

    public void setPrevious(Control previous) {
        this.previous = previous;
    }

    public Control getPrevious() {
        return this.previous;
    }
}

